/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "text.h"

GLuint CText::mLists;

void CText::Init(void)
{
 	mLists=glGenLists(224);

	for(int i=0; i<224; ++i)
 	{
		float cx=float(i%16)/16;
		float cy=float(i/16)/14;
		float sx=1.f/16;
		float sy=1.f/14;
		
 		glNewList(mLists+i,GL_COMPILE);
		
		glBegin(GL_QUADS);
		glNormal3f(0.0f,0.0f,-1.0f);
		glTexCoord2f(cx,1-cy-sy);
		glVertex2f(0.f,0.f);
		glTexCoord2f(cx+sx,1-cy-sy);
		glVertex2f(1.f,0.f);
		glTexCoord2f(cx+sx,1-cy);
		glVertex2f(1.f,1.f);
		glTexCoord2f(cx,1-cy);
		glVertex2f(0.f,1.f);
		glEnd();

 		glTranslatef(1.f,0.f,0.f);
 		glEndList();
	}
}

void CText::Cleanup(void)
{
	glDeleteLists(mLists,256);
}

CText::CText(void) : 
	mFont(NULL),
	mWidth(10.f),
	mHeight(20.f),
	mCenter(false)
{

}

CText::CText(const std::string &text,pMaterial font,bool center) :
	mText(text),
	mFont(font),
	mWidth(10.f),
	mHeight(20.f),
	mCenter(center)
{
	updateTextRadius();
}

CText::~CText(void)
{

}

void CText::setFont(pMaterial font,float width,float height)
{
	mFont=font;
	mWidth=width;
	mHeight=height;
	updateTextRadius();
}

pMaterial CText::getFont(void) const
{
	return mFont;
}

void CText::setText(const std::string &text)
{
	mText=text;
	updateTextRadius();
}

const std::string &CText::getText(void) const
{
	return mText;
}

void CText::setCentered(bool center)
{
	if(mCenter != center)
	{
		mCenter = center;
		updateTextRadius();
	}
}

void CText::updateTextRadius(void)
{
	size_t eol=mText.find('\n',0);
	if(eol==std::string::npos) eol=mText.size();
	setRadius(std::sqrt(sqr(eol*mWidth/(1.f+float(mCenter)))+sqr(mHeight/2.f)));
}

int CText::Draw( int pass)
{
	if(pass == 0) return 0;

	int count=0;
	if(!mText.empty() && mFont!=NULL && mFont->Bind(pass))
	{
		// OPTI: moyen de rarranger (while i<eol...)
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glScalef(mWidth,mHeight,1.f);
	
		int line=0;
		
		if(mCenter)
		{
			size_t eol=mText.find('\n',0);
			if(eol==std::string::npos) eol=mText.size();
			glTranslatef(-float(eol)/2,0.f,0.f);
		}
		
		for(size_t i=0; i<mText.size(); ++i)
		{
			if(mText[i]=='\n')
			{
				++line;
				glPopMatrix();
				glPushMatrix();
				
				if(mCenter)
				{
					size_t eol=mText.find('\n',i+1);
					if(eol==std::string::npos) eol=mText.size();
					glTranslatef(-float(eol-i)/2,0.f,0.f);
				}

				glTranslatef(0.f,-float(line),0.f);
			}
			else if((unsigned char)(mText[i])>=32)
			{
				glCallList(mLists+(unsigned char)(mText[i])-32);
				count+=2;
			}
		}

		glPopMatrix();
		mFont->Unbind();
	} 
	return count;
}
