/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "terrainloader.h"
#include "mediamanager.h"
#include "resourcemanager.h"
#include <IL/il.h>

CTerrainLoader::CTerrainLoader(void)
{
	// IL charge dans CImageLoader
}

CTerrainLoader::~CTerrainLoader(void)
{
	// IL dcharge dans CImageLoader
}

CTerrain* CTerrainLoader::Load(const std::string &filename)
{
	ILuint imageNbr=0;
	ilGenImages(1,&imageNbr);
	ilBindImage(imageNbr);

	if(!ilLoadImage(const_cast<ILstring>(filename.c_str())))
		throw CLoadingFailed(filename,"Impossible de charger la heightmap");
	if(!ilConvertImage(IL_LUMINANCE,IL_FLOAT)) 
		throw CLoadingFailed(filename,"Impossible de convertir la heightmap");

	int cols=ilGetInteger(IL_IMAGE_WIDTH);
	int rows=ilGetInteger(IL_IMAGE_HEIGHT);
	const float *data=reinterpret_cast<const float *>(ilGetData());
	
	pTerrain terrain = new CTerrain(1.f,1.f,cols,rows,1,1,NULL,data);

	ilDeleteImages(1,&imageNbr);

	return terrain;
}