/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef TERRAIN_H
#define TERRAIN_H

#include "octree.h"
#include "include.h"

class CTerrain : public COctree
{
public:
	CTerrain(	float sizex,
				float sizey,
				int nbrx,
				int nbry,
				int detailx=1,
				int detaily=1,
				pMaterial material=NULL,
				const float *heightmap=NULL);

	virtual ~CTerrain();

	void setHeight(int x,int y,float height);
	void setHeight(const float *heightmap,float scale=1.f,int cols=-1,int rows=-1);
	void setHeight(const std::string &heightmap,float scale=1.f);
	
	float getHeight(int x,int y);
	float getGroundHeight(float x,float y);
	CVector3 getNormal(int x,int y);
	CVector3 getGroundNormal(float x,float y);

	void updateNormals(void);

private:
	int			mNbrx,mNbry;
	float		mScalex,mScaley;

};

typedef CSmartPtr<CTerrain> pTerrain;

#endif
