/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SPRITE_H
#define SPRITE_H

#include "entity.h"
#include "particle.h"
#include "scene.h"
#include "include.h"

class CSprite : public CEntity
{
public:
	CSprite(void);
	CSprite(float x,float y,pMaterial material);
	virtual ~CSprite(void);

	inline void setMaterial(pMaterial mat)			{mMaterial = mat;}
	inline pMaterial getMaterial(void)				{return mMaterial;}
	void setSize(float x,float y);

	void Parameter(const std::string &param,const std::string &data);
	void Register(pScene scene);

private:
	pMaterial material;
	float mSizex,mSizey;
};

typedef CSmartPtr<CSprite> pSprite;

class CAlignedSprite : public CSprite
{
public:
	CAlignedSprite(void);
	CAlignedSprite(float x,float y,pMaterial material=NULL);
	virtual ~CAlignedSprite(void);

	void Parameter(const std::string &param,const std::string &data);
	
	bool getLockAxis(CVector3 &axis) const;		// dans le repre global !
	void setLockAxis(const CVector3 &axis);

private:
	CVector3 mAxis;
};

typedef CSmartPtr<CAlignedSprite> pAlignedSprite;

#endif
