/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SOUND_H
#define SOUND_H

#include "entity.h"
#include "sample.h"
#include "include.h"

class CSound : public CEntity
{
public:
	static void Init(void);
	static void Cleanup(void);
	static void Process(void);
	static void setGlobalGain(float volume);	// utilisation interne seulement
	static void Listener(pEntity entity,double time);
	
	CSound(pSample sample=NULL);
	virtual ~CSound(void);
	
	void setSample(pSample sample);
	pSample getSample(void) const;

	void Play(bool loop=false);
	void Stop(void);
	
	bool isPlaying(void);
	float getGain(void);
	float getPitch(void);
	void setGain(float volume);
	void setPitch(float pitch);
	
	virtual void Parameter(const std::string &param,const std::string &data);
	virtual bool Update(double time);

private:
	static CCoord3 ListenerOldPos;
	static CVector3 ListenerVelocity;
	
	ALuint			mSource;
	pSample			mSample;
	CCoord3			mOldPos;
	CVector3		mVelocity;
};

typedef CSmartPtr<CSound> pSound;

#endif
