/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "scriptloader.h"
#include "mediamanager.h"
#include "resourcemanager.h"

CScriptLoader::CScriptLoader(void)
{

}

CScriptLoader::~CScriptLoader(void)
{

}

CScript* CScriptLoader::Load(const std::string &filename)
{
	// Ouverture du fichier
	std::ifstream file;
	file.open(filename.c_str(),std::ios::in);
	if(!file.is_open()) throw CLoadingFailed(filename, "Ouverture impossible");

	// Lecture
	std::string str;
	char chr = file.get();
	while(!file.eof()) 
	{
		if(!file.good()) 
			throw CLoadingFailed(filename, "Erreur de lecture");
		str+=chr;
		chr = file.get();
	}

	return new CScript(str);
}