/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "scriptable.h"
#include "mediamanager.h"



void IScriptable::Script(const std::string &filename)
{
	try {
		Script(MediaManager->Get<CScript>(filename));
	}
	catch(const CException &e)
	{
		throw CLoadingFailed(filename,e.what());
	}

	// TODO: prvoir le cas de plusieurs scripts  la suite !
	mScript = filename;	// se souvient du script
}

void IScriptable::Script(pScript script)
{
	std::istringstream in(script->getData());
	Script(in);
}

void IScriptable::Script(std::istream &in)
{
	for(;;)
	{
		// Lit le tag suivant
		in.ignore(1024,'<');
		if(in.eof()) break;

		//Si c'est une fermeture
		if(in.peek()=='/')
		{
			in.ignore(1024,'>');
			break;
		}

		// Sinon on lit le tag
		char chr;
		std::string tag;
		while(in.get(chr))
		{
			if(chr == '>' || chr == ' '|| chr == '\t') break;
			else if(chr != '\n' && chr != '\r') tag+=chr;
		}
		
		pScriptable child = NULL;
		for(int i=0; i<tag.size(); ++i) tag[i] = tolower(tag[i]);
		if(tag != "this")
		{
			child = Tag(tag);
			if(child == NULL)
				throw CException(std::string("Balise invalide: ")+tag);
		}
		
		// Boucle de lecture des paramtres
		while(chr!='>')
		{
			// Cherche le dbut
			while(in.get(chr))
				if(chr == '>' || (chr != '\n' && chr != '\r' && chr != ' ' && chr != '\t')) 
					break;

			// Si on a trouv un nouveau paramtre
			if(chr != '>')
			{
				// Lit le nom du paramtre
				std::string param;
				param+=chr;
				while(in.get(chr))
				{
					if(chr == '=') break;
					else if(chr != '\n' && chr != '\r' && chr != ' ' && chr != '\t')
						param+=chr;
				}
				
				// Lit la valeur
				while(in.get(chr))
					if(chr == '\'' || chr == '\"') 
						break;
				
				std::string value;
				while(in.get(chr))
				{
					if(chr == '\"' || chr =='\'') break;
					else value+=chr;
				}

				// On applique
				if(child != NULL) child->Parameter(param,value);
				else Parameter(param,value);
			}
		}

		if(child != NULL) child->Script(in);
	}
}
