/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef RESOURCEMANAGER_H
#define RESOURCEMANAGER_H

#include "resource.h"
#include "singleton.h"
#include "smartptr.h"
#include "include.h"

class CResourceManager : public ISingleton<CResourceManager>
{
public :

    // Rcupre une ressource
    template <class T> CSmartPtr<T> Get(const std::string& name) const;

    // Ajoute une ressource
    void Add(const std::string& name, pResource resource);

    // Retire une ressource
    void Remove(const std::string& name);

	// Retire les ressources inutilises
	void Flush(void);

private :

    CResourceManager();
    ~CResourceManager();

	friend class ISingleton<CResourceManager>;

	//Table contenant les ressources associes  leur nom de fichier
    typedef std::map<std::string, pResource> ResourcesMap_t;
    ResourcesMap_t mResources;
};

#define ResourceManager CResourceManager::Instance()

#include "resourcemanager.inl"

#endif // RESOURCEMANAGER_H
