/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "resourcemanager.h"

// Constructeur par dfaut
CResourceManager::CResourceManager()
{

}

// Destructeur
CResourceManager::~CResourceManager()
{

}

// Ajoute une ressource
void CResourceManager::Add(const std::string &name, pResource resource)
{
   if(resource!=NULL) mResources[name] = resource;
}

// Retire une ressource
void CResourceManager::Remove(const std::string &name)
{
    // Recherche de la ressource dans la table
    ResourcesMap_t::iterator it = mResources.find(name);

     // Retrait de la ressource de la liste
	if (it != mResources.end()) mResources.erase(it);
}

// Retire les ressources inutilises
void CResourceManager::Flush(void)
{
	for(ResourcesMap_t::iterator it = mResources.begin(); it != mResources.end(); )
	{
		if((it->second == NULL) || (it->second->getRefCount() == 1)) 
			mResources.erase(it++);
		else ++it;
	}
}
