/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "pointlight.h"

// Constructeur
CPointLight::CPointLight(void) : mExponent(0.f), mCutoff(180.f)
{
	mAttenuation[0]=1.f;
	mAttenuation[1]=0.f;
	mAttenuation[2]=0.f;
}

// Destructeur
CPointLight::~CPointLight(void)
{

}

void CPointLight::setAttenuation(float constant,float linear,float quadratic)
{
	mAttenuation[0]=constant;
	mAttenuation[1]=linear;
	mAttenuation[2]=quadratic;
}

void CPointLight::setExponent(float exponent)
{
	mExponent=exponent;
}

void CPointLight::setCutoff(float cutoff)
{
	mCutoff=cutoff;
}

int CPointLight::Draw(int pass)
{
	if(pass != 0) return 0;
	if(mCastShadow) CScene::Current->RegisterShadowLight(this);
	
	int num=GL_LIGHT0+currentLightNum;
	
	glEnable(num);

	float pos[4]={0.f,0.f,0.f,1.f};
	*reinterpret_cast<CVector3*>(pos)=getGlobalMatrix().getTranslation();
	glLightfv(num,GL_POSITION,pos);
	
	glLightfv(num,GL_AMBIENT,mAmbient);
	glLightfv(num,GL_DIFFUSE,mDiffuse);
	glLightfv(num,GL_SPECULAR,mSpecular);
	
	glLightf(num,GL_CONSTANT_ATTENUATION,mAttenuation[0]);
	glLightf(num,GL_LINEAR_ATTENUATION,mAttenuation[1]);
	glLightf(num,GL_QUADRATIC_ATTENUATION,mAttenuation[2]);

	float direc[4]={0.f,0.f,0.f,1.f};
	*reinterpret_cast<CVector3*>(direc) = getGlobalMatrix().NoTranslation().getAxisZ();
	glLightfv(num,GL_SPOT_DIRECTION,direc);
	
	glLightf(num,GL_SPOT_EXPONENT,mExponent);
	glLightf(num,GL_SPOT_CUTOFF,mCutoff);

	++currentLightNum;
	return 0;
}
