/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef PLANE_H
#define PLANE_H

#include "vector3.h"
#include "include.h"

class CPlane
{
public:
 
	// Constructeur
	CPlane(float _a=0.f,float _b=0.f,float _c=0.f,float _d=0.f);
	
	// Destructeur
	~CPlane(void);
	
	CVector3 Normal(void);
	float Norm(void) const;
	CPlane &Normalize(void);
	
	// Donnes membres
	float a,b,c,d;

	operator const float*() const;
	operator float*();
};

#include "plane.inl"

#endif // PLANE_H
