/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MESH_H
#define MESH_H

#include "resource.h"
#include "buffer.h"
#include "material.h"
#include "vector3.h"
#include "smartptr.h"
#include "include.h"

class CMesh;
typedef CSmartPtr<CMesh> pMesh;

// Classe CMesh: reprsente une structure tridimensionnelle
class CMesh : public IResource
{
public:
	typedef unsigned int index_t;
	#define INVALID_INDEX (index_t(-1))

	// Constructeur
	CMesh(	const float *vertices, 
			index_t nvertices,
			index_t *indices, 
			index_t nindices,
			const float **texcoords,
			int ntexcoords);
	// Destructeur
	virtual ~CMesh(void);
	
	// Spcifie un matriau dans la srie d'indices (NULL pour supprimer)
	void setMaterial(pMaterial material, index_t offset=0);
	// Retourne le rayon de la sphre englobante
	float getRadius(void) const;

	// ATTENTION: l'ajout est couteux
	void Add(	const float *vertices, 
				index_t nvertices,
				index_t *indices, 
				index_t nindices,
				const float **texcoords,
				int ntexcoords);

	virtual void EnableShadowVolume(void);
	virtual void DisableShadowVolume(void);
	
	bool hasBlending(void);
	
	virtual int Draw(int pass,double frame,pMaterial force = NULL);
	virtual int DrawShadowVolume(double frame,const CVector3 &light,bool directional);
	virtual float Intersect(double frame,const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection);

protected:
	CMesh(void);
	void Copy(pMesh mesh);
	
	// Sous-routines de dessin
	virtual void EnableBuffers(void) const;
	void DisableBuffers(void) const;
	int DrawElements(int pass,index_t pos, index_t nbr) const;
	
	typedef CBuffer<float>			VertexBuffer_t;
	typedef CBuffer<float>			NormalBuffer_t;
	typedef CBuffer<float>			TexCoordBuffer_t;
	typedef CBuffer<unsigned char>	ColorBuffer_t;
	typedef CBuffer<index_t>		IndexBuffer_t;

	// Buffers
	CSmartPtr<IndexBuffer_t>		mIndexBuffer;		// Indices
	CSmartPtr<VertexBuffer_t>		mVertexBuffer;		// Vertices
	CSmartPtr<NormalBuffer_t>		mNormalBuffer;		// Normales
	CSmartPtr<TexCoordBuffer_t>		*mTexCoordBuffers;	// Coordonnes de texture
	index_t	mNbrVertices;
	index_t	mNbrIndices;
	int		mNbrTexCoords;

	// Matriaux avec leurs indices
	typedef std::map<index_t,pMaterial>	MaterialsMap_t;
	MaterialsMap_t	mMaterials;

	float mRadius;	// Rayon du mesh

	index_t	*mFaceNeighbours;	// Faces voisines pour shadow volume
};

#endif
