/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "resourcemanager.h"

// Enregistre un nouveau chargeur de media
template <class T>
inline void CMediaManager::RegisterLoader(ILoader<T>* loader, const std::string &extensions)
{
    if(loader!=NULL) 
	{
		// Rcupration des extensions
		std::string::size_type p=0,oldp=0;
		for(;;)
		{
			p=extensions.find_first_of(" /\\*.,;|",p);
			if(p-oldp>1)
			{
				std::string ext(extensions,oldp,p-oldp);
				//std::transform(ext.begin(),ext.end(),ToLower);
				
				CMediaHolder<T>::mLoaders.insert(make_pair(ext,loader));
			}

			if(p==std::string::npos) break;
			oldp=++p;
		}
	}
}

// Supprime un chargeur
template <class T>
inline void CMediaManager::UnregisterLoader(const std::string& extensions)
{
	CMediaHolder<T>::mLoaders.erase(extensions);
}


// Charge un media
template <class T>
inline CSmartPtr<T> CMediaManager::Load(const std::string &filename) const
{
    // Recherche du fichier dans les rpertoires enregistrs
	std::string fullpath = FindMedia(filename);

    // On appelle le loader appropri
    CSmartPtr<T> media = FindLoader<T>(filename).Load(fullpath);

	// On enregistre la ressource
	CResourceManager::Instance()->Add(fullpath,media);

    return media;
}

 // Retourne la ressource si dj charge, sinon charge
template <class T>
inline CSmartPtr<T> CMediaManager::Get(const std::string &filename) const
{
	// Recherche directement la ressource
	CSmartPtr<T> media = CResourceManager::Instance()->Get<T>(filename);
    if(media!=NULL) return media;
	
	// Recherche du fichier dans les rpertoires enregistrs
	std::string fullpath = FindMedia(filename);

	// Recherche la ressource
	media = CResourceManager::Instance()->Get<T>(fullpath);
    if(media!=NULL) return media;

	// Sinon on appelle le loader appropri
    media = FindLoader<T>(filename).Load(fullpath);

	// On enregistre la ressource
	CResourceManager::Instance()->Add(fullpath,media);

    return media;
}

// Cherche le loader correspondant  un fichier donn
template <class T>
inline ILoader<T> &CMediaManager::FindLoader(const std::string &filename) const
{
	std::string::size_type p=filename.find_last_of('.');
	if(p!=std::string::npos)
	{
		std::string extension(filename,++p);
		//std::transform(extension.begin(),extension.end(),ToLower);

		// Recherche de l'extension dans la map de loaders
		typename CMediaHolder<T>::LoadersMap_t::const_iterator it = CMediaHolder<T>::mLoaders.find(extension);

		// On renvoie le loader appropri
		if ((it != CMediaHolder<T>::mLoaders.end()) && (it->second!=NULL))
			return *it->second;
	}

	// On lance une exception si non trouv
    throw CLoadingFailed(filename, "Aucun loader ne prend en charge ce format de fichier");
}
