/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MEDIAMANAGER_H
#define MEDIAMANAGER_H

#include "loader.h"
#include "exception.h"
#include "singleton.h"
#include "smartptr.h"
#include "include.h" 

template <class T>
struct CMediaHolder
{
    typedef std::map<std::string, CSmartPtr<ILoader<T> > > LoadersMap_t;
    LoadersMap_t mLoaders; // Chargeurs de T associs  leur extension
};

class CMesh;
class COctree;
class CMaterial;
class CImage;
class CTexture;
class CSample;
class CMusic;
class CTerrain;
class CScript;

class CMediaManager : public ISingleton<CMediaManager>,
	public CMediaHolder<CMesh>,
	public CMediaHolder<COctree>,
	public CMediaHolder<CMaterial>,
	public CMediaHolder<CImage>,
	public CMediaHolder<CTexture>,
	public CMediaHolder<CSample>,
	public CMediaHolder<CMusic>,
	public CMediaHolder<CTerrain>,
	public CMediaHolder<CScript>
{

public:
	// Ajoute un rpertoire de recherche de medias
    void AddPath(std::string path);

    // Enregistre un nouveau chargeur
    template <class T> void RegisterLoader(ILoader<T>* loader, const std::string &extensions);

    // Supprime un chargeur
    template <class T> void UnregisterLoader(const std::string &extension);

    // Charge  partir d'un fichier
	template <class T> CSmartPtr<T> Load(const std::string &filename) const;

	 // Retourne la ressource si dj charge, sinon charge
	template <class T> CSmartPtr<T> Get(const std::string &filename) const;

	// Trouve un fichier
	std::string FindMedia(std::string filename) const;

private :
    CMediaManager();
    ~CMediaManager();

	friend class ISingleton<CMediaManager>;

	// Trouve un loader
    template <class T> ILoader<T> &FindLoader(const std::string &filename) const;

    std::set<std::string> mPaths; // Liste des chemins de recherche
};

#define MediaManager CMediaManager::Instance()

#include "mediamanager.inl"

#endif // MEDIAMANAGER_H
