/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MATRIX4_H
#define MATRIX4_H

#include "include.h"

class CQuaternion;
class CVector3;

class CMatrix4
{
public:

	// Constructeur par dfaut
	CMatrix4(float m11 = 1.0f, float m12 = 0.0f, float m13 = 0.0f, float m14 = 0.0f,
             float m21 = 0.0f, float m22 = 1.0f, float m23 = 0.0f, float m24 = 0.0f,
             float m31 = 0.0f, float m32 = 0.0f, float m33 = 1.0f, float m34 = 0.0f,
             float m41 = 0.0f, float m42 = 0.0f, float m43 = 0.0f, float m44 = 1.0f);

	// Identit
	void Identity(void);
	// Dterminant
	float Determinant(void) const;
	// Transpose
	CMatrix4 Transpose(void) const;
	// Inverse
	CMatrix4 Inverse(void) const;
	
	CMatrix4 NoTranslation(void) const;
	
	void setTranslation(const CVector3 &v);
	void setRotation(float x,float y,float z);
	void setRotation(const CQuaternion &q);
	void setScale(const CVector3 &s);

	void Translate(const CVector3 &v);
	void Rotate(float x,float y,float z);
	void Rotate(const CQuaternion &q);
	void Scale(const CVector3 &s);

	CVector3 getTranslation(void) const;
	CQuaternion getRotation(void) const;
	CVector3 getAxisX(void) const;
	CVector3 getAxisY(void) const;
	CVector3 getAxisZ(void) const;
	CVector3 getScale(void) const;
	
	void Normalize(void);	// Normalise la base
	
	// Application
	CVector3 Transform(const CVector3 &v, float w = 1.0f) const;
	void Apply(void) const;
	void Load(void) const;
	void Get(GLenum name);
	
	// Multiplication
    CMatrix4 operator *(const CMatrix4& m) const;
    const CMatrix4& operator *=(const CMatrix4& m);

	// Oprateur d'accs
    float& operator ()(std::size_t i, std::size_t j);
    const float& operator ()(std::size_t i, std::size_t j) const;
	
	// cast en const float*
	operator const float*() const;
	// cast en float*
	operator float*();

private:
	float a11, a21, a31, a41;
	float a12, a22, a32, a42;
	float a13, a23, a33, a43;
	float a14, a24, a34, a44;
};

#include "quaternion.h"
#include "vector3.h"

#include "matrix4.inl"

#endif	//MATRIX4_H
