/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "imageloader.h"
#include <IL/il.h>

// Constructeur
CImageLoader::CImageLoader()
{
	// Initalisation de DevIL
	ilInit();

	// On indique que l'origine des images se trouve sur le coin haut-gauche
	ilOriginFunc(IL_ORIGIN_LOWER_LEFT);
	ilEnable(IL_ORIGIN_SET);

	// On force le chargement des images en 32 bits RGBA
	//ilSetInteger(IL_FORMAT_MODE, IL_RGBA);
	//ilEnable(IL_FORMAT_SET);

	ilEnable(IL_CONV_PAL);
}

// Destructeur
CImageLoader::~CImageLoader()
{
    // Fermeture de DevIL
    ilShutDown();
}

// Charge une image
CImage* CImageLoader::Load(const std::string& filename)
{
	// Gnration d'une nouvelle image
	ILuint image;
	ilGenImages(1, &image);
	ilBindImage(image);

	try
	{
		// Chargement de l'image
		if(!ilLoadImage(const_cast<ILstring>(filename.c_str())))
			throw CLoadingFailed(filename, "Impossible de charger l'image");

		return new CImage(image);
	}
	catch(...)
	{
		ilDeleteImages(1,&image);
		throw;
	}
}


