/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "cubemap.h"
#include "matrix4.h"
#include "vector3.h"

CCubeMap::CCubeMap(pImage front,pImage back,pImage right,pImage left,pImage top,pImage bottom) : 
	CTexture(NULL)
{
	mTarget=GL_TEXTURE_CUBE_MAP;
	
	if(GLEW_ARB_texture_cube_map)
	{				    
		glBindTexture(mTarget, mTexNbr);
		
		pImage images[6];
		images[0]=left;
		images[1]=right;
		images[2]=bottom;
		images[3]=top;
		images[4]=back;
		images[5]=front;
		
		for(int i=0;i<6;++i)
			if(images[i]!=NULL)
				images[i]->BuildTexture(GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT+i);

		mMode=GL_REFLECTION_MAP;
	}
}
	
// Destructeur
CCubeMap::~CCubeMap(void)
{

}

void CCubeMap::Bind(GLint wrap)
{
	if(GLEW_ARB_texture_cube_map)
	{
		CTexture::Bind(GL_CLAMP_TO_EDGE);
		
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, mMode);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, mMode);
		glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, mMode);
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);
		glEnable(GL_TEXTURE_GEN_R);
	}
}

void CCubeMap::Unbind()
{
	if(GLEW_ARB_texture_cube_map)
	{
		CTexture::Unbind();		
	    
		glDisable(GL_TEXTURE_GEN_S);
		glDisable(GL_TEXTURE_GEN_T);
		glDisable(GL_TEXTURE_GEN_R);
	}
}
