/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef COLOR_H
#define COLOR_H

#include "include.h"

class CColor
{
public:
	
	// Donnes membres
	float r,g,b,a;

	// Constructeurs
	CColor(float _r=1.f,float _g=1.f,float _b=1.f,float _a=1.0f);
	CColor(int _r,int _g,int _b,int _a=255);
	CColor(const std::string &s);
	
	// Destructeur
	~CColor(void);
	
	void set(float _r,float _g,float _b,float _a=1.0f);
	void set(int _r,int _g,int _b,int _a=255);
	
	void Display(void) const;

	CColor &operator*=(float f);
	CColor operator*(float f);

	// cast en const float*
	operator const float*() const;
	// cast en int*
	operator float*();
};

inline std::istream &operator >>(std::istream &in,CColor &color)
{
	int r,g,b,a;
	in>>r;
	in>>g;
	in>>b;
	if(!(in>>a)) a = int(color.a*255);
	color.set(r,g,b,a);
	return in;
}

inline CColor::CColor(const std::string &s)
{
	std::stringstream ss(s);
	ss>>*this;
}

#endif	// COLOR_H
