/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef BUFFERBASE_H
#define BUFFERBASE_H

#include "smartptr.h"
#include "include.h"

// Classe IBufferBase
// Stocke des donnes non types
class IBufferBase : public IRefCount
{
public:
	IBufferBase(void) : mSize(0) {}
	virtual ~IBufferBase(void) {}
	
	virtual void Fill(const void *ptr,size_t size,GLenum usage=GL_STATIC_DRAW) =0;
	virtual void Replace(size_t offset,const void *ptr,size_t size) =0;
	virtual void *Bind(void) =0;
	virtual void Unbind(void) =0;
	virtual void *Offset(size_t offset) =0;
	virtual void *Lock(size_t offset,size_t size,GLenum access=GL_READ_ONLY) =0;
	virtual void Unlock(void) =0;

protected:
	size_t mSize;
};

#endif
