/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "bufferarray.h"

// constructeur
CBufferArray::CBufferArray(void) : mBuffer(NULL)
{

}

// destructeur
CBufferArray::~CBufferArray(void)
{
	delete [] mBuffer;
}

void *CBufferArray::Bind(void)
{
	if(!mBuffer) throw CException("Attache d'un buffer nul");
	return mBuffer;
}

void CBufferArray::Unbind(void)
{
	// rien  faire
}

// Offset en pointeur
void *CBufferArray::Offset(size_t offset)
{
	return mBuffer+offset;
}

// remplit le buffer
void CBufferArray::Fill(const void *ptr,size_t size,GLenum usage)
{
	if(size!=mSize)
	{
		delete [] mBuffer;
		mBuffer=new char[size];
		mSize=size;
	}

	if(ptr!=NULL)
	{
		const char *p=reinterpret_cast<const char*>(ptr);
		std::copy(p,p+size,mBuffer);
	}
}

// remplace une zone du buffer
void CBufferArray::Replace(size_t offset,const void *ptr,size_t size)
{
	const char *p=reinterpret_cast<const char*>(ptr);
	std::copy(p,p+size,mBuffer+offset);
}

// verrouille
void *CBufferArray::Lock(size_t offset,size_t size,GLenum access)
{
	return mBuffer+offset;
}

// dverrouille
void CBufferArray::Unlock(void)
{
	// rien  faire
}
