/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Constructeur
template <class T>
CBuffer<T>::CBuffer(CSmartPtr<IBufferBase> buffer)
{
	Assert(buffer!=NULL);
	mBuffer = buffer;
	mCount = 0;
}

// Destructeur
template <class T>
CBuffer<T>::~CBuffer(void)
{

}

// retourne le nombre d'lments
template <class T>
size_t CBuffer<T>::getCount(void) const
{
	return mCount;
}					

// Attache
template <class T>
void *CBuffer<T>::Bind(void)
{
	return mBuffer->Bind();
}
	
// Dtache
template <class T>
void CBuffer<T>::Unbind(void)
{
	mBuffer->Unbind();
}

// Offset en pointeur
template <class T>
void *CBuffer<T>::Offset(size_t offset)
{
	return mBuffer->Offset(offset*sizeof(T));
}

// remplit le buffer
template <class T>
void CBuffer<T>::Fill(const T *ptr,size_t nbr,GLenum usage)
{
	mBuffer->Fill(ptr,nbr*sizeof(T),usage);
	mCount=nbr;
}

// remplace une zone
template <class T>
void CBuffer<T>::Replace(size_t offset,const T *ptr,size_t nbr)
{
	mBuffer->Replace(offset*sizeof(T),ptr,nbr*sizeof(T));
}

// verrouille le buffer pour accs
template <class T>
T *CBuffer<T>::Lock(size_t offset,size_t nbr,GLenum access)
{
		return reinterpret_cast<T*>(mBuffer->Lock(offset*sizeof(T),nbr*sizeof(T),access));
}

// dverrouille le buffer
template <class T>
void CBuffer<T>::Unlock(void)
{
	mBuffer->Unlock();
}

// Ajoute des donnes  la suite
template <class T>
void CBuffer<T>:: Add(const T *ptr,size_t nbr,GLenum usage)
{
	if(!nbr) return;
	if(!mCount) {
		Fill(ptr,nbr,usage);
		return;
	}

	// Alloue un espace tampon
	T *temp = new T[mCount+nbr];
	
	// Copie l'ancien buffer
	const T *p = Lock(0,mCount,GL_READ_ONLY);
	std::copy(p,p+mCount,temp);
	Unlock();

	// Copie le nouveau  la suite
	if(ptr) std::copy(ptr,ptr+nbr,temp+mCount);
	else std::fill(temp+mCount,temp+mCount+nbr,T(0));

	// Remplit avec les nouvelles donnes
	Fill(temp,mCount+nbr,usage);
}
