/*********************************************************/
/* Ramanujan's algorithm to calculate Pi		 */
/* http://en.wikipedia.org/wiki/Ramanujan#Mathematical_achievements */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler				 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2005-12-31					 */
/* Last Change: 2006-01-24				 */
/* CVS-Version: nA					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2005,2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <stdio.h>

long double fac(long double i)
{
	if(i==0)
		return 1;
	else
		return i*fac(i-1);
}

long double expo(long double a, long double b)
{
	if (b==0) return 1; // a^0 = 1
	long double help=a;
	int i;

	for (i=1; i<b; i++)
		help *= a;

	return help;
}


int main(int argc, char *argv[])
{
	long double i, one_over_pi=0;

	
	for (i=0; i<=atoi(argv[1]); i++)
	{

		one_over_pi += ( fac(4*i) * (1103 + 26390*i ) ) / ( expo(fac(i), 4) * expo(396, 4*i) );
		printf ("%6.0Lf : %.62Lf \n", i, 
		1./(  ( 2*sqrt(2) * 1./ 9801 )  *  one_over_pi  ));

// the same:	printf ("%6.0Lf : %.62Lf \n", i, 
//		1./(  ( (sqrt(8) ) / 9801  )  *  one_over_pi ) ); // is identical
	}

}
