/*********************************************************/
/* Main file to execute some alogrithm of our project	 */
/* to calculate Pi					 */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler, Pascal Fricke		 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2006-01-06					 */
/* Last Change: 2006-01-11				 */
/* CVS-Version: 1.2					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <iostream>


char *decission_algo()
{
	int algo_count;
	char *argv[0];
	
	printf("%s "  ,	"Which algorithm do you want to use for the calculation?");
	scanf("%d"    ,	&algo_count);

	switch(algo_count)
	{
		case 1 :	argv[0] = "./bbp";				break;
		case 2 :	argv[0] = "./leonhard_euler";			break;
		case 3 :	argv[0] = "./johann_heinrich_lambert";		break;
		case 4 :	argv[0] = "./gottfried_wilhelm_leibniz";	break;
		case 5 :	argv[0] = "./srinivasa_aiyangar_ramanujan";	break;
		case 6 :	argv[0] = "./franois_vite";			break;
		case 7 :	argv[0] = "./john_wallis";			break;
//		default:	printf("%s \n",	"You should enter a number from above."); break;
	}	
	
	return argv[0];
}

void print_menu()
{
	printf("\n %s \n", "PI - Calculator - (C) 2005,2006 Sebastian Wieseler [GPL]");
	printf(" %s\n\n" , "========================================================");

	printf("%s \n",	" 1) Bailey-Borwein-Plouffe formula");
	printf("%s \n",	" 2) Euler formula");
	printf("%s \n",	" 3) Lambert formula");
	printf("%s \n",	" 4) Leibnitz formula");
	printf("%s \n",	" 5) Ramanujan formula");
	printf("%s \n",	" 6) Vite formula");
	printf("%s \n",	" 7) Wallis formula");
	printf("\n");
}

int main()
{
	char *argv[3], *envp[1];
	char algo_run[0];
	
	// print the menu
	print_menu();
	
	// ask what algorithm to use
	argv[0] = decission_algo();
	
	// ask how many runs we should do with our algorithm
	printf("%s ",	"How many runs?");
	scanf("%s"  ,	algo_run);
	
	argv[1] = algo_run;
	argv[2] = 0;		/* terminate argv list */
	envp[0] = 0;		/* empty environment for argv[0] */

	// execute my algorithm
	execve(argv[0],argv,envp);

		
	// print the bad truth - we are not perfect :(
	printf("%s %.62f \n", " The original Pi is:", 3.141592653589793238462643383279502884197169399375);

	return 0; 
}
