/*********************************************************/
/* Lambert's algorithm to calculate Pi			 */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler, Pascal Fricke		 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2005-12-27					 */
/* Last Change: 2006-01-24				 */
/* CVS-Version: nA					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2005,2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <stdio.h>


// Pi = 4./(n+1);
// i = atoi(argv[1]) -- counter;
long double lambert_algo(float n, long double i)
{
	if (n < i)
		return ((n*n)/(((2*n)+1)+lambert_algo(n+1,i)));
	else if (n == i) // should be else
		return 1;
}

int main(int argc, char *argv[])
{
	long double i;
	for (i=1; i<=atoi(argv[1]); i++)
	{
		printf ("%6.0Lf : %.62Lf \n", i, 
		4./(lambert_algo(1,i)+1) ); 	
	}
}
