/*********************************************************/
/* Bailey-Borwein-Plouffe formula to calculate Pi by	 */
/* David H. Bailey, Peter Borwein and Simon Plouffe ('97)*/
/* http://en.wikipedia.org/wiki/BBP_formula		 */
/* http://crd.lbl.gov/~dhbailey/pi/pi-alg		 */
/* http://mathworld.wolfram.com/BBP-TypeFormula.html	 */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler				 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2006-01-03					 */
/* Last Change: 2006-01-24				 */
/* CVS-Version: nA					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <stdio.h>

long double expo(long double a, long double b)
{
	if (b==0) return 1; // a^0 = 1
	long double help=a;

	int i;
	for (i=1; i<b; i++)
		help *= a;

	return help;
};


int main(int argc, char *argv[])
{
	long double pi=0;

	long double i;

	for (i=0; i<atoi(argv[1]); i++)
	{
		pi += 1./expo(16,i) * ( 4./(8*i+1) - 2./(8*i+4) - 1./(8*i+5) - 1./(8*i+6) );
		printf ("%6.0Lf : %.60Lf \n", i+1, pi);
	};

	return 0;
};
