/*********************************************************/
/* Main file to execute some alogrithm of our project	 */
/* to calculate Pi					 */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler, Pascal Fricke		 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2006-01-06					 */
/* Last Change: 2006-01-25				 */
/* CVS-Version: 1.2					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include "mymath.h"

#include "bbp.h"
#include "leonhard_euler.h"
#include "johann_heinrich_lambert.h"
#include "gottfried_wilhelm_leibniz.h"
#include "srinivasa_aiyangar_ramanujan.h"
#include "francois_viete.h"
#include "john_wallis.h"

void run_algo(int decision_algo, long double decision_passes)
{
	switch(decision_algo)
	{
		case 1 :	bbp(decision_passes);				break;
		case 2 :	leonhard_euler(decision_passes);		break;
		case 3 :	johann_heinrich_lambert(decision_passes);	break;
		case 4 :	gottfried_wilhelm_leibniz(decision_passes);	break;
		case 5 :	srinivasa_aiyangar_ramanujan(decision_passes);	break;
		case 6 :	francois_viete(decision_passes);		break;
		case 7 :	john_wallis(decision_passes);			break;
		default:	printf("%s \n",	"You should enter a number from above."); break;
	}
	
}

void print_header()
{
	printf("\n %s \n", "PI - Calculator - (C) 2005,2006 Sebastian Wieseler [GPL]");
	printf(" %s\n\n" , "========================================================");
}


void print_menu()
{
	printf("%s \n",	" 1) Bailey-Borwein-Plouffe formula");
	printf("%s \n",	" 2) Euler formula");
	printf("%s \n",	" 3) Lambert formula");
	printf("%s \n",	" 4) Leibnitz formula");
	printf("%s \n",	" 5) Ramanujan formula");
	printf("%s \n",	" 6) Viete formula");
	printf("%s \n",	" 7) Wallis formula");
	printf("\n");
}

int main(int argc, char* argv[])
{
	/* declare some variables */
	int decision_algo;
	long double decision_passes;

	/* print the header */
	print_header();

	if (argc == 3)
	{
		decision_algo = atoi(argv[1]);	/* string to integer */
		decision_passes = atol(argv[2]);/* string to long */
	}

	else
	{
		/* print the menu */
		print_menu();

		/* ask what algorithm to use */
		printf(" %s" ,	"Which algorithm do you want to use for the calculation? ");
		scanf("%d"   ,	&decision_algo);

		/* ask how many runs/passes we should do with our algorithm */
		printf(" %s" ,	"How many iterations of the algorithm should be passed through? ");
		scanf("%Lf"  ,	&decision_passes);
	}


	/* run the algorithm */
	run_algo(decision_algo, decision_passes);
	
	/* print the bad truth - we are not perfect (yet) :( */
	printf("%s %.62f \n", " The faithfull Pi is:", 3.141592653589793238462643383279502884197169399375);

	return 0; 
}
