/*********************************************************/
/* Viete formula to calculate Pi			 */
/* http://en.wikipedia.org/wiki/Vi%C3%A8te_formula	 */
/* ----------------------------------------------------- */
/* Autor: Sebastian Wieseler, Pascal Fricke		 */
/* Mail: programming@kickino.org			 */
/* Web: http://www.kickino.org/				 */
/* IRC: #uscc @ irc.forkbomb.ch:6668 (ssl only)		 */
/* ----------------------------------------------------- */
/* Date: 2005-12-31					 */
/* Last Change: 2006-01-25				 */
/* CVS-Version: 1.2					 */
/* ----------------------------------------------------- */
/* tested OS: GNU/Linux					 */
/* Copyright: 2005,2006 by Sebastian Wieseler		 */
/* ----------------------------------------------------- */
/* License: GNU General Public License v2 or any later	 */
/* ----------------------------------------------------- */
/* NO WARRANTY!                                          */
/*********************************************************/
/*	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


/* was my first try to run viete_formula :-)
 *long double viete_formula0(int n)
 *{
 *	// you need a 'const int pass=30' e.g. for doing this
 *	// never tried to implement argc[1] for that, sorry man :(
 *	long double a[pass];
 *
 *	if (n==1)
 *		return sqrt(2); // a[1]=sqrt(2)
 *
 *
 *	a[n] = sqrt( 2 + viete_formula0(n-1) );
 *	// a[n] = sqrt(2 + a[n-1]);
 *
 *	return a[n];
 *}
 */

long double viete_formula(long double n)
{
	if (n==1)
		return sqrt(2); /* a[1]=sqrt(2) */

	return sqrt( 2 + viete_formula(n-1) );
	
}

void francois_viete(long double passes)
{

	long double two_over_pi = sqrt(2)/2;
	long double i;

	for (i=2; i<=passes; i++)
	{
		two_over_pi *= viete_formula(i) / 2;
		printf ("%6.0Lf: %.62Lf \n", i, 2/two_over_pi );
	}
}
