<?
include_once("test.php");

function waitKeyQ() {
	$ended=0;
	while ($ended==0) {
		while (SDL_PollEvent(&$event)) {
			switch($event["type"]) {					
			case SDL_QUIT:
				echo "SDL_Quit received, quitting\n";
				$ended=1;
				break;
			case SDL_KEYDOWN:
				$keysym=$event["key"]["keysym"]["sym"];
				if ($keysym==SDLK_q) {
					echo "Q pressed, quitting\n";
					$ended=1;
				}
				break;
			}
		}
	}
}

dl('sdl.so');
class test_t001 extends test{
	function do_test($idx) {
		switch($idx) {
		case 1:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font1=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font1);
			$srf=sdlttf_RenderText_Solid($font1,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font2=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderText_Solid($font2,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font3=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderText_Solid($font3,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			sdlttf_SetFontStyle($font2,TTF_STYLE_ITALIC+TTF_STYLE_UNDERLINE);
			$srf=sdlttf_RenderText_Solid($font2,"Hello world",255,0,0);
			$sty=sdlttf_GetFontStyle($font2);
			var_dump($sty);

			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=200;			

			
			SDL_BlitSurface($srf,NULL,$screen,$r);

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font1);
			sdlttf_closeFont($font2);
			sdlttf_closeFont($font3);

			$ret=sdlttf_quit();
			var_dump($ret);
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 2:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			$text="àèìòù àèìòù àèìòù";
			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderUTF8_Solid($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUTF8_Solid($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUTF8_Solid($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();
			
			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			echo "Quitting\n";
			break;

		case 3:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderText_Shaded($font,"Hello world",255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderText_Shaded($font,"Hello world",255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderText_Shaded($font,"Hello world",255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			echo "Quitting\n";
			break;

		case 4:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			$text="àèìòù àèìòù àèìòù";
			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderUTF8_Shaded($font,$text,255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUTF8_Shaded($font,$text,255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUTF8_Shaded($font,$text,255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			echo "Quitting\n";
			break;

		case 5:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderText_Blended($font,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderText_Blended($font,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderText_Blended($font,"Hello world",255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 6:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			$text="àèìòù àèìòù àèìòù";
			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderUTF8_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUTF8_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUTF8_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			echo "Quitting\n";
			break;
	
		case 7:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			echo "Font reso\n";
			print_r($font);
			echo "\n";
			$r=sdlttf_FontHeight($font);
			echo "FontHeight\n";
			var_dump($r);
			
			$ret=sdlttf_quit();
			echo "TTF_Quit\n";
			var_dump($ret);
			
			$ret=SDL_Quit();
			echo "SDL_Quit\n";
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 8:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			echo "Font reso\n";
			print_r($font);
			echo "\n";
			$r=sdlttf_FontAscent($font);
			echo "FontAscent\n";
			var_dump($r);
			
			$ret=sdlttf_quit();
			echo "TTF_Quit\n";
			var_dump($ret);
			
			$ret=SDL_Quit();
			echo "SDL_Quit\n";
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 9:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			echo "Font reso\n";
			print_r($font);
			echo "\n";
			$r=sdlttf_FontDescent($font);
			echo "FontDescent\n";
			var_dump($r);
			
			$ret=sdlttf_quit();
			echo "TTF_Quit\n";
			var_dump($ret);
			
			$ret=SDL_Quit();
			echo "SDL_Quit\n";
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 10:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);
			$text1 = "abcdefà awpooxpo ";
			$expanded = iconv("UTF-8", "UTF-16", $text1);
			$text=$expanded;

			$font1=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font1);
			$srf=sdlttf_RenderUNICODE_Solid($font1,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font2=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUNICODE_Solid($font2,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font3=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUNICODE_Solid($font3,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			sdlttf_SetFontStyle($font2,TTF_STYLE_ITALIC+TTF_STYLE_UNDERLINE);
			$srf=sdlttf_RenderUNICODE_Solid($font2,$text,255,0,0);
			$sty=sdlttf_GetFontStyle($font2);
			var_dump($sty);

			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=200;			

			
			SDL_BlitSurface($srf,NULL,$screen,$r);

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font1);
			sdlttf_closeFont($font2);
			sdlttf_closeFont($font3);

			$ret=sdlttf_quit();
			var_dump($ret);
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 11:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$text1 = "abcdefà awpooxpo ";
			$expanded = iconv("UTF-8", "UTF-16", $text1);
			$text=$expanded;


			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderUNICODE_Shaded($font,$text,255,0,0,0,0,01);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUNICODE_Shaded($font,$text,255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUNICODE_Shaded($font,$text,255,0,0,0,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			echo "Quitting\n";
			break;

		case 12:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			$text1 = "abcdefà awpooxpo ";
			$expanded = iconv("UTF-8", "UTF-16", $text1);
			$text=$expanded;

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			print_r($font);
			$srf=sdlttf_RenderUNICODE_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=50;			
			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","48");
			$srf=sdlttf_RenderUNICODE_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=90;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			$font=sdlttf_OpenFont("contrib/FreeSans.ttf","96");
			$srf=sdlttf_RenderUNICODE_Blended($font,$text,255,0,0);
			$r=$srf["clip_rect"];
			$r['x']+=50;
			$r['y']+=120;			

			SDL_BlitSurface($srf,NULL,$screen,$r);			

			SDL_UpdateRect($screen,0,0,800,600);
						
			waitKeyQ();

			sdlttf_closeFont($font);	
			sdlttf_quit();
			SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 13:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			function drawString($font,$target,$text,$x,$y,$r,$g,$b,$mode="solid") {
				$srf=sdlttf_RenderText_Solid($font,$text,$r,$g,$b);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}
			function drawChar($font,$target,$ch,$x,$y,$r,$g,$b) {
				$srf=sdlttf_RenderGlyph_Solid($font,$ch,$r,$g,$b);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font1=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			
			//drawString($font1,$screen,$stylename,50,72,255,255,255);
			$size=120;
			$font2=sdlttf_OpenFont("contrib/FreeSans.ttf",$size);
			$familyname=sdlttf_FontFaceFamilyName($font2);
			$stylename=sdlttf_FontFaceStyleName($font2);
			$height=sdlttf_FontHeight($font2);
			drawString($font1,$screen,"Family: $familyname, size: $size, style: $stylename, maxsize: $height",50,50,255,255,255);

			drawChar($font2,$screen,ord('g'),50,150,255,255,255,0);

			$minx=$miny=$maxx=$maxy=$advance=0;
			sdlttf_GlyphMetrics($font2,ord('g'),&$minx,&$maxx,&$miny,&$maxy,&$advance);

			drawString($font1,$screen,"MINX: $minx",50,270,255,255,255);
			drawString($font1,$screen,"MINY: $miny",50,300,255,255,255);
			drawString($font1,$screen,"MAXX: $maxx",50,330,255,255,255);
			drawString($font1,$screen,"MAXY: $maxy",50,360,255,255,255);
			drawString($font1,$screen,"ADVANCE: $advance",50,390,255,255,255);

			
			$ox=50; $oy=150;
			sdlgfx_lineRGBA($screen,$ox,$oy,$ox+100,$oy,255,0,0,255);
			sdlgfx_rectangleRGBA($screen,$ox+$minx,$oy+$miny,$ox+$maxx,$oy+$maxy,255,0,0,255);

			drawString($font1,$screen,"press Q to exit",50,500,255,255,255);
			SDL_UpdateRect($screen,0,0,800,600);

			
						

			waitKeyQ();

			sdlttf_closeFont($font1);
			sdlttf_closeFont($font2);

			$ret=sdlttf_quit();
			$ret=SDL_Quit();
			echo "Quitting\n";
			break;


		case 14:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			function drawString($font,$target,$text,$x,$y,$r,$g,$b,$mode="solid") {
				$srf=sdlttf_RenderText_Blended($font,$text,$r,$g,$b);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}
			function drawChar($font,$target,$ch,$x,$y,$r,$g,$b) {
				$srf=sdlttf_RenderGlyph_Blended($font,$ch,$r,$g,$b);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font1=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			
			//drawString($font1,$screen,$stylename,50,72,255,255,255);
			$size=120;
			$font2=sdlttf_OpenFont("contrib/FreeSans.ttf",$size);
			$familyname=sdlttf_FontFaceFamilyName($font2);
			$stylename=sdlttf_FontFaceStyleName($font2);
			$height=sdlttf_FontHeight($font2);
			drawString($font1,$screen,"Family: $familyname, size: $size, style: $stylename, maxsize: $height",50,50,255,255,255);

			drawChar($font2,$screen,ord('g'),50,150,255,255,255,0);

			$minx=$miny=$maxx=$maxy=$advance=0;
			sdlttf_GlyphMetrics($font2,ord('g'),&$minx,&$maxx,&$miny,&$maxy,&$advance);

			drawString($font1,$screen,"MINX: $minx",50,270,255,255,255);
			drawString($font1,$screen,"MINY: $miny",50,300,255,255,255);
			drawString($font1,$screen,"MAXX: $maxx",50,330,255,255,255);
			drawString($font1,$screen,"MAXY: $maxy",50,360,255,255,255);
			drawString($font1,$screen,"ADVANCE: $advance",50,390,255,255,255);

			
			$ox=50; $oy=150;
			sdlgfx_lineRGBA($screen,$ox,$oy,$ox+100,$oy,255,0,0,255);
			sdlgfx_rectangleRGBA($screen,$ox+$minx,$oy+$miny,$ox+$maxx,$oy+$maxy,255,0,0,255);

			drawString($font1,$screen,"press Q to exit",50,500,255,255,255);
			SDL_UpdateRect($screen,0,0,800,600);			

			waitKeyQ();

			sdlttf_closeFont($font1);
			sdlttf_closeFont($font2);

			$ret=sdlttf_quit();
			$ret=SDL_Quit();
			echo "Quitting\n";
			break;


		case 15:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			sdlttf_Init();

			function drawString($font,$target,$text,$x,$y,$r,$g,$b,$mode="solid") {
				$srf=sdlttf_RenderText_Shaded($font,$text,$r,$g,$b,0,0,0);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}
			function drawChar($font,$target,$ch,$x,$y,$r,$g,$b) {
				$srf=sdlttf_RenderGlyph_Shaded($font,$ch,$r,$g,$b,0,0,0);
				$rect=$srf["clip_rect"];
				$rect['x']+=$x;
				$rect['y']+=$y;			
				SDL_BlitSurface($srf,NULL,$target,$rect);				
			}

			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(800, 600, 32, $flags);

			$font1=sdlttf_OpenFont("contrib/FreeSans.ttf","24");
			
			//drawString($font1,$screen,$stylename,50,72,255,255,255);
			$size=120;
			$font2=sdlttf_OpenFont("contrib/FreeSans.ttf",$size);
			$familyname=sdlttf_FontFaceFamilyName($font2);
			$stylename=sdlttf_FontFaceStyleName($font2);
			$height=sdlttf_FontHeight($font2);
			drawString($font1,$screen,"Family: $familyname, size: $size, style: $stylename, maxsize: $height",50,50,255,255,255);

			drawChar($font2,$screen,ord('g'),50,150,255,255,255,0);

			$minx=$miny=$maxx=$maxy=$advance=0;
			sdlttf_GlyphMetrics($font2,ord('g'),&$minx,&$maxx,&$miny,&$maxy,&$advance);

			drawString($font1,$screen,"MINX: $minx",50,270,255,255,255);
			drawString($font1,$screen,"MINY: $miny",50,300,255,255,255);
			drawString($font1,$screen,"MAXX: $maxx",50,330,255,255,255);
			drawString($font1,$screen,"MAXY: $maxy",50,360,255,255,255);
			drawString($font1,$screen,"ADVANCE: $advance",50,390,255,255,255);

			
			$ox=50; $oy=150;
			sdlgfx_lineRGBA($screen,$ox,$oy,$ox+100,$oy,255,0,0,255);
			sdlgfx_rectangleRGBA($screen,$ox+$minx,$oy+$miny,$ox+$maxx,$oy+$maxy,255,0,0,255);

			drawString($font1,$screen,"press Q to exit",50,500,255,255,255);
			SDL_UpdateRect($screen,0,0,800,600);			

			waitKeyQ();

			sdlttf_closeFont($font1);
			sdlttf_closeFont($font2);

			$ret=sdlttf_quit();
			$ret=SDL_Quit();
			echo "Quitting\n";
			break;


		}
	}
	function get_test_list() {
		return array(
			1=>"testing rendertext_solid",
			2=>"testing renderutf8_solid",
			3=>"testing rendertext_shaded",
			4=>"testing renderutf8_shaded",
			5=>"testing rendertext_blended",
			6=>"testing renderutf8_blended",
			7=>"testing fontheight",
			8=>"testing fontascent",
			9=>"testing fontdescent",
			10=>"testing renderunicode_solid",
			11=>"testing renderunicode_shaded",
			12=>"testing renderunicode_blended",
			13=>"testing familyname, stylename and glyphMetrics, solid",
			14=>"testing familyname, stylename and glyphMetrics, blended",
			15=>"testing familyname, stylename and glyphMetrics, shaded",
		);
	}
}
?>
