<?
include_once("test.php");

function waitKeyQ() {
	$ended=0;
	while ($ended==0) {
		while (SDL_PollEvent(&$event)) {
			switch($event["type"]) {					
			case SDL_QUIT:
				echo "SDL_Quit received, quitting\n";
				$ended=1;
				break;
			case SDL_KEYDOWN:
				$keysym=$event["key"]["keysym"]["sym"];
				if ($keysym==SDLK_q) {
					echo "Q pressed, quitting\n";
					$ended=1;
				}
				break;
			}
		}
	}

}
dl('sdl.so');
class test_g001 extends test{
	function do_test($idx) {
		switch($idx) {
		case 1:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 24, $flags);
			$fmt=$screen["format"];
// MapRGBA and MapRGB returns 0xff0000 (for red...)
// Correct value is 0xff000ff
// probably sdlgfx are functions with alpha.

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			$green=SDL_MapRGB($fmt,0,255,0)<<8|0xff;
			$blue=SDL_MapRGB($fmt,0,0,255)<<8|0xff;	
			sdlgfx_pixelColor($screen,10,10,$red);
			sdlgfx_pixelColor($screen,10,15,$green);
			sdlgfx_pixelColor($screen,10,20,$blue);									

			sdlgfx_hlineColor($screen,40,100,20,$red);
			sdlgfx_hlineColor($screen,40,100,40,$green);
			sdlgfx_hlineColor($screen,40,100,60,$blue);									
	
			sdlgfx_vlineColor($screen,20,60,200,$red);
			sdlgfx_vlineColor($screen,40,60,200,$green);
			sdlgfx_vlineColor($screen,60,60,200,$blue);									

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;
		case 2:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			sdlgfx_pixelRGBA($screen,10,10,255,0,0,255);
			sdlgfx_pixelRGBA($screen,10,15,0,255,0,255);
			sdlgfx_pixelRGBA($screen,10,20,0,0,255,255);									

			sdlgfx_hlineRGBA($screen,40,100,20,255,0,0,255);
			sdlgfx_hlineRGBA($screen,40,100,40,0,255,0,255);
			sdlgfx_hlineRGBA($screen,40,100,60,0,0,255,255);
	
			sdlgfx_vlineRGBA($screen,20,60,200,255,0,0,255);
			sdlgfx_vlineRGBA($screen,40,60,200,0,255,0,255);
			sdlgfx_vlineRGBA($screen,60,60,200,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 3:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			$green=SDL_MapRGB($fmt,0,255,0)<<8|0xff;
			$blue=SDL_MapRGB($fmt,0,0,255)<<8|0xff;	

			sdlgfx_rectangleColor($screen,10,10,100,100,$red);
			sdlgfx_boxColor($screen,120,10,220,100,$green);

			sdlgfx_lineColor($screen,300,300,500,400,$blue);
			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 4:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			sdlgfx_rectangleRGBA($screen,10,10,100,100,255,0,0,255);
			sdlgfx_boxRGBA($screen,120,10,220,100,0,255,0,255);

			sdlgfx_lineRGBA($screen,300,300,500,400,0,0,255,255);
			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 5:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			$yellow=SDL_MapRGB($fmt,255,255,0)<<8|0xff;

			sdlgfx_circleColor($screen,200,200,50,$red);
			sdlgfx_filledcircleColor($screen,300,200,50,$yellow);			

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 6:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			sdlgfx_circleRGBA($screen,200,200,50,255,0,0,255);
			sdlgfx_filledcircleRGBA($screen,300,200,50,255,255,0,255);			

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 7:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			$yellow=SDL_MapRGB($fmt,255,255,0)<<8|0xff;

			sdlgfx_ellipseColor($screen,200,200,50,20,$red);
			sdlgfx_filledEllipseColor($screen,300,200,50,20,$yellow);			

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 8:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			sdlgfx_ellipseRGBA($screen,200,200,50,20,255,0,0,255);
			sdlgfx_filledEllipseRGBA($screen,300,200,50,20,255,0,255,255);			

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 9:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			$green=SDL_MapRGB($fmt,0,255,0)<<8|0xff;
			$blue=SDL_MapRGB($fmt,0,0,255)<<8|0xff;	

			sdlgfx_aalineColor($screen,300,300,500,400,$blue);
			sdlgfx_aaellipseColor($screen,200,200,50,20,$red);
			sdlgfx_aacircleColor($screen,200,300,50,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 10:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);

			sdlgfx_aalineRGBA($screen,300,300,500,400,0,0,255,255);
			sdlgfx_aaellipseRGBA($screen,200,200,50,20,255,0,0,255);
			sdlgfx_aacircleRGBA($screen,200,300,50,255,0,0,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 11:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_pieColor($screen,300,300,100,0,91.003,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 12:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			sdlgfx_pieRGBA($screen,300,300,100,0,91,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 13:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_filledPieColor($screen,300,300,100,0,91.003,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 14:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			sdlgfx_filledPieRGBA($screen,300,300,100,0,91,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 15:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_trigonColor($screen,100,100,100,300,200,60,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 16:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			sdlgfx_trigonRGBA($screen,100,100,100,300,200,60,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 17:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_aatrigonColor($screen,100,100,100,300,200,60,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 18:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			sdlgfx_aatrigonRGBA($screen,100,100,100,300,200,60,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 19:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_filledTrigonColor($screen,100,100,100,300,200,60,$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 20:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];

			sdlgfx_filledTrigonRGBA($screen,100,100,100,300,200,60,0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;


		case 21:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_characterColor($screen,100,120,"b",$red);
			sdlgfx_stringColor($screen,100,100,"abcdef",$red);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 22:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;

			sdlgfx_characterRGBA($screen,100,120,"a",0,0,255,255);
			sdlgfx_stringRGBA($screen,100,100,"abcdef",0,0,255,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 23:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			/*
				10,50
								100,70
				       30,90
				10,150
			*/
			$x=array(10,100,30,10);
			$y=array(50,70,90,150);
			sdlgfx_polygonColor($screen,$x,$y,$red);
			$y1=$y;
			for ($i=0;$i<4;$i++) 
				$x1[$i]=$x[$i]+200;			
				
			sdlgfx_polygonRGBA($screen,$x1,$y1,255,255,0,255);			
			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 24:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			/*
				10,50
								100,70
				       30,90
				10,150
			*/
			$x=array(10,100,30,10);
			$y=array(50,70,90,150);
			sdlgfx_aapolygonColor($screen,$x,$y,$red);
			$y1=$y;
			for ($i=0;$i<4;$i++) 
				$x1[$i]=$x[$i]+200;			
				
			sdlgfx_aapolygonRGBA($screen,$x1,$y1,255,255,0,255);			
			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 25:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			/*
				10,50
								100,70
				       30,90
				10,150
			*/
			$x=array(10,100,30,10);
			$y=array(50,70,90,150);
			sdlgfx_filledpolygonColor($screen,$x,$y,$red);
			$y1=$y;
			for ($i=0;$i<4;$i++) 
				$x1[$i]=$x[$i]+200;			
				
			sdlgfx_filledpolygonRGBA($screen,$x1,$y1,255,255,0,255);			
			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 26:
			echo "Starting\n";
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			$fmt=$screen["format"];
			$red=SDL_MapRGB($fmt,255,0,0)<<8|0xff;
			/*
				
				10,10-50,100-100,10-150,100
				
				
			*/
			$x=array(10,50,100,150,200,250,300,350);
			$y=array(10,100,100,10,10,100,100,10);
			$y1=$y;
			for ($i=0;$i<sizeof($x);$i++) {
				$x[$i]+=150;
				$y[$i]+=180;				
				$y1[$i]+=280;				
			}
			sdlgfx_bezierColor($screen,$x,$y,7,$red);
			sdlgfx_bezierRGBA($screen,$x,$y1,7,255,255,0,255);

			SDL_UpdateRect($screen,0,0,640,480);						

			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
			break;

		case 27:
			SDL_Init(SDL_INIT_VIDEO);
			$flags=SDL_HWSURFACE;
			$screen=SDL_SetVideoMode(640, 480, 32, $flags);
			
			echo "Starting\n";
			$r=255; $g=0; $b=0;
			sdlgfx_initFramerate(&$fps);
			for ($i=0;$i<10000;$i++) {
				$x=rand(0,639); $y=rand(0,479); $r=rand(0,255);
				sdlgfx_pixelRGBA($screen,$x,$y,$r,$g,$b,255);
				SDL_UpdateRect($screen,$x,$y,$x,$y);
			}
			echo "Done";
			waitKeyQ();

			// cleaning.
			sdlgfx_boxRGBA($screen,0,0,640,480,0,0,0,255);
			SDL_UpdateRect($screen,0,0,640,480);

			// testing lines
			for ($i=0;$i<5000;$i++) {
				$x1=rand(0,639); $y1=rand(0,479); 
				$x2=rand(0,639); $y2=rand(0,479); 
				$r=rand(0,255);
				sdlgfx_lineRGBA($screen,$x1,$y1,$x2,$y2,$r,$g,$b,255);
				SDL_UpdateRect($screen,0,0,640,480);
				if ($i%1000==0) echo sdlgfx_getFramerate($fps)."\n";
			}

			waitKeyQ();

			// cleaning.
			sdlgfx_boxRGBA($screen,0,0,640,480,0,0,0,255);
			SDL_UpdateRect($screen,0,0,640,480);

			// testing boxes
			for ($i=0;$i<5000;$i++) {
				$x1=rand(0,639); $y1=rand(0,479); 
				$x2=rand(0,639); $y2=rand(0,479); 
				$r=rand(0,255);
				sdlgfx_boxRGBA($screen,$x1,$y1,$x2,$y2,$r,$g,$b,255);
				SDL_UpdateRect($screen,0,0,640,480);
				if ($i%1000==0) echo sdlgfx_getFramerate($fps)."\n";
			}
			
			waitKeyQ();
			$ret=SDL_Quit();
			
			var_dump($ret);
			echo "Quitting\n";
		}
	}
	function get_test_list() {
		return array(
			1=>"pixels, hlines, vlines with color",
			2=>"pixels, hlines, vlines with rgba",			
			3=>"rects, boxes and lines with color",
			4=>"rects, boxes and lines with rgba",			
			5=>"circles and filled circles with color",
			6=>"circles and filled circles with rgba",	
			7=>"ellipses and filled ellipses with color",
			8=>"ellipses and filled ellipses with rgba",	
			9=>"aalines aacircles and aaellipses with color",
			10=>"aalines aacircles and aaellipses with rgba",
			11=>"pies with color",
			12=>"pies with rgba",
			13=>"filled pies with color",
			14=>"filled pies with rgba",
			15=>"trigon color",
			16=>"trigon rgba",
			17=>"aatrigon color",
			18=>"aatrigon rgba",
			19=>"filled trigon color",
			20=>"filled trigon rgba",
			21=>"characterColor and stringColor",
			22=>"characterRGBA and stringRGBA",
			23=>"polygonColor and polygonRGBA",
			24=>"aapolygonColor and aapolygonRGBA",
			25=>"filledpolygonColor and filledpolygonRGBA",
			26=>"bezierColor and bezierRGBA",
			27=>"massive points",
		);
	}
}
?>
