#!/usr/bin/php -q
<?
/*
 * gen_referencebook.php
 * This file is part of PHP_ExtGenerator
 *
 * Copyright (C) 2008 - Dimitri Giardina
 *
 * PHP_ExtGenerator is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PHP_ExtGenerator is distributed in the hope that it will be useful,
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PHP_ExtGenerator; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
	//parse_ini_file($argv[0]);
	
	function generate_docbook($glob) {
		$extensions=$glob->info[0]->extensions[0]->extension;
		$exts["main"]=array("name"=>"main","description"=>"all functions","condition"=>"");		
		foreach($extensions as $e) {
			$name=(string)$e["name"];
			$description=(string)$e["title"];
			$condition=(string)$e["condition"];
			$i=array(
				"name"=>$name,
				"description"=>$description,
				"condition"=>$condition
			);
			$exts[$i["name"]]=$i;
		}				
		foreach($exts as $e) {
			gen_subdocbook($e,$glob);
		}
	}
	function gen_subdocbook($e,$glob) {
		echo "<chapter><title>".$e["description"]." Reference </title>";
				
		$basefun=$glob->functions[0];
		$baseconst=$glob->constants[0];			
		$baseres=$glob->resources[0];			
		$basefun_found=false;
		$baseconst_found=false;
		$baseres_found=false;
		
		if ($e["name"]!="main") {
			foreach($glob->functions[0]->condition as $c) {
				if ((string)$c["value"]==$e["condition"])  {
					$basefun=$c;
					$basefun_found=true;
				}
			}

			foreach($glob->constants[0]->condition as $c) {
				if ((string)$c["value"]==$e["condition"])  {
				
					$baseconst=$c;
					$baseconst_found=true;					
				}
			}
			
			foreach($glob->resources[0]->condition as $c) {
				if ((string)$c["value"]==$e["condition"])  {				
					$baseres=$c;
					$baseres_found=true;					
				}
			}
			
		} else {
			$basefun_found=true;
			$baseconst_found=true;
			$baseres_found=true;
		}			
		
		//echo "\t<section><title>Functions</title>\n\n";
		if ($basefun_found) {
			foreach ($basefun->function as $f) {
				$definition=(string)($f->def[0]["value"]);
				$r=gen_parse_fun($definition);
				$ret=$r[0];
				echo "\t<refentry id='".$f["name"]."'>\n";
				echo "\t\t<refnamediv>\n";
				echo "\t\t\t<refname>".$f["name"]."</refname>\n";
				echo "\t\t\t<refpurpose>Here Description2</refpurpose>\n";
				echo "\t\t</refnamediv>\n";
				echo "\t\t<refsynopsisdiv>\n";
				echo "\t\t<funcsynopsis>\n";
				echo "\t\t\t<funcprototype>\n";
				echo "\t\t\t\t<funcdef>$ret <function>".$f["name"]."</function></funcdef>\n";
				echo "\t\t\t\t".$r[1]."\n";
				echo "\t\t\t</funcprototype>\n";
				echo "\t\t</funcsynopsis>\n";
				echo "\t\t</refsynopsisdiv>\n";
				echo "\t\t<refsect1><title>Description</title>\n";
				echo "\t\t<para>Here description</para>\n";
				echo "\t\t</refsect1>\n";
				echo "\t</refentry>\n\n";
			}
		}
		//echo "\t</section>\n";
		
		echo "\t<section><title>Constants</title>\n\n";		
		if ($baseconst_found) {
			foreach ($baseconst->const as $f) {
				echo "<para><constant>".$f["name"]."</constant></para>\n";
			}
		}
		
		echo "\t</section>\n";
				
		echo "\t<section><title>Resources</title>\n\n";				
		if ($baseres_found) {
			foreach ($baseres->resource as $f) {
				echo "<para><const>".$f["name"]."</const></para>\n";
			}
		}
		echo "\t</section>\n\n";
		echo "</chapter>\n";
	}
	
	function gen_parse_fun($v) {
		$x=explode("(",$v);
		$buf="";
		$x1=$x[0];
		$x2=str_replace(")","",$x[1]);
		$ret=explode(" ",$x1);
		if ($x2!="void" && $x2!="") {
			$args1=explode(",",$x2);
			for($i=0;$i<sizeof($args1);$i++){						
				$a=explode(" ",trim($args1[$i]));
				$ptr=$a[1]{0};
				//conv_funpara($a,&$arg);
				if ($a[1]{0}=="*") $a[1]=substr($a[1],1);
				$buf.="<paramdef>".$a[0]." <parameter>$".$a[1]."</parameter></paramdef>";
				$args[]=$arg;
			}
			// generate var containers.
		}
		return array($ret[0],$buf);
	}

	if (sizeof($argv)>0 && file_exists($argv[1])) {
		$glob=simplexml_load_file($argv[1]);
		$out=$argv[2];
		if ($out=="") die("");
		
		$hdr=<<<HDR
<book>
	<bookinfo>
		<title>phpsdl-ng Reference</title>
		<author><firstname>Dimitri</firstname><surname>Giardina</surname></author>
	</bookinfo>
HDR;
		$ftr=<<<FTR
</book>		
FTR;
		ob_start();
		echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		echo $hdr;
		generate_docbook($glob);
		echo $ftr;
		
		$buf=ob_get_contents();
		ob_end_clean();
		$fp=fopen($out.".docbook","w");
		fputs($fp,$buf);
		fclose($fp);
	}
?>
