PHP_ARG_ENABLE(sdl,
  [ whattawhatta ],
  [ --with-sdl        Enable "sdl" extension support]) 
      
if test $PHP_SDL != "no"; then 
	PHP_SUBST(SDL_SHARED_LIBADD) 
	PHP_NEW_EXTENSION(sdl, sdl.c, $ext_shared) 
  

PHP_ARG_WITH(sdl, [for sdl Support]
[  with-sdl	      Include SDL Support]) 

if test "$PHP_SDL" != "no"; then
	if test "$PHP_SDL" = "yes"; then
		SDL_LIST="/usr/local /usr"
	else
		SDL_LIST="$PHP_SDL /usr/local /usr"
	fi
	SDL_SUBLIST="none 12 11"
	SDL_CONFIG=""

	AC_MSG_CHECKING(for sdl-config)
	for i in $SDL_LIST; do
		for j in $SDL_SUBLIST; do
			if test "x$j" = "xnone"; then
				tmp=""
			else
				tmp=$j
			fi
			if test -x "$i/bin/sdl$tmp-config"; then
				SDL_CONFIG="$i/bin/sdl$tmp-config"
			fi
		done
		if test -n "$SDL_CONFIG"; then
			break
		fi
	done

	if test -n "$SDL_CONFIG"; then
		AC_MSG_RESULT(found in $SDL_CONFIG)

		PHP_EVAL_INCLINE(`$SDL_CONFIG --cflags`)

		dnl Try to extract SDL_DIR to find SDL_Image
		SDL_DIR=""
		for i in $SDL_CFLAGS; do
			case $i in
				-I*SDL*)
					SDL_INCDIR=`echo $i | cut -c 3-`
					AC_MSG_CHECKING(for SDL_image.h in $SDL_INCDIR)
					if test -f "$SDL_INCDIR/SDL_image.h"; then
						AC_DEFINE(HAVE_SDL_IMAGE, 1, [ ])
						SDL_IMAGE=yes
						AC_MSG_RESULT(found)
						PHP_ADD_LIBRARY(SDL_image, 1, SDL_SHARED_LIBADD)
					else
						AC_MSG_RESULT(not found)
					fi
					if test -f "$SDL_INCDIR/SDL_gfxPrimitives.h"; then
						AC_DEFINE(HAVE_SDL_GFX,1 , [ ])
						SDL_GFX=yes
						AC_MSG_RESULT(found)
						PHP_ADD_LIBRARY(SDL_gfx, 1, SDL_SHARED_LIBADD)
					else
						AC_MSG_RESULT(not found)
					fi			      

					if test -f "$SDL_INCDIR/SDL_ttf.h"; then
						AC_DEFINE(HAVE_SDL_TTF,1 , [ ])
						SDL_TTF=yes
						AC_MSG_RESULT(found)
						PHP_ADD_LIBRARY(SDL_ttf, 1, SDL_SHARED_LIBADD)
					else
						AC_MSG_RESULT(not found)
					fi			      
					;;
			esac
		done


		dnl FIXME: support non-shared builds
		SDL_LIBS=`$SDL_CONFIG --libs`
		for i in $SDL_LIBS; do
			case $i in
				-L*)
					tmp=`echo $i | cut -c 3-`
					PHP_ADD_LIBPATH($tmp, SDL_SHARED_LIBADD)
					;;
				-l*)
					tmp=`echo $i | cut -c 3-`
					PHP_ADD_LIBRARY($tmp, 1, SDL_SHARED_LIBADD)
					;;
			esac
		done
	fi
fi
		
fi		