<?php
/*
 *Example of use of PrintIPP
 *
 * Copyright(C) 2008 Thomas Harding
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Thomas Harding nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 *   mailto:thomas.harding@laposte.net
 *
 */


$debug = 0;
error_reporting(E_ALL|E_STRICT);
/* printing an utf-8 file */
require_once('../CupsPrintIPP.php'); 
$ipp = new CupsPrintIPP(); 
$ipp->with_exceptions = 1;

//
$ipp->setHost("localhost");
  // various tests for ipv6 and SSL you can enable instead
	//$ipp->setHost("ip6-localhost");
	//$ipp->setHost("127.0.0.1");
	//$ipp->setHost("::1");
	//$ipp->ssl = 1;
	$ipp->setPort("631");
$ipp->setPrinterURI("/printers/Parallel_Port_1"); 
$ipp->debug_level = 3; // Debugging very verbose
$ipp->setLog('/tmp/printipp','file',3); // logging very verbose
$ipp->setUserName("www-data"); // setting user name for server
$ipp->setDocumentName("testfile with UTF-8 characters");
$ipp->setCharset('utf-8');
$ipp->setMimeMediaType('text/plain');
$ipp->setAttribute('number-up',1); // pages per sheet
$ipp->setSides(1); // by default: 2 = two-sided-long-edge // other choices: 1 = one-sided // 2CE = two-sided-short-edge
$ipp->setData("./test-utf8.txt");//Path to file.
try
{
  printf(_("Job status: %s\n"), $ipp->printJob()); // Print job, display job status 
  printf(_("Cancel job: %s"), $ipp->CancelJob($ipp->last_job)); // comment to deforrest ;)
}
catch (httpException $e)
{
  printf("%s\nerrno: %s\n",$e->getMessage(),$e->getErrno());
  trigger_error("I prefer to quit", E_USER_ERROR);
}
if ($debug)
  $ipp->printDebug(); // display debugging output
?>

END "PRINT THEN CANCEL" TEST
<?php exit (0) ?>
