<?php
/*
 *Example of use of PrintIPP
 *
 * Copyright(C) 2005-2006 Thomas Harding
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Thomas Harding nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 *   mailto:thomas.harding@laposte.net
 *   Thomas Harding, 56 rue de la bourie rouge, 45 000 ORLEANS -- FRANCE
 *
 */

/**********************************************************
*
*   S E T U P
*
***********************************************************/

$host = "geekette.localdomain"; // set serve'rs host here
$printer_uri = "/printers/epson"; // set printer uri here
$language = "fr_fr";
$user = "test"; // valid user from lpadmin group
$password = "test"; // his password
$document_uri = "http://localhost/";

error_reporting(E_ALL);
/******************
*
* END OF SETUP
*
*******************/


require_once("Tiny.php"); // other files are loaded by it

echo "<html><head></head><body><h1>PHP PrintIPP example</h1>";

echo "Note that all options are not showed here<br />";

//$ipp = new PrintIPP(); // Basic PrintIPP
//$ipp = new ExtendedPrintIPP(); // extended IPP
$ipp = new PrintIPP(); // extended IPP with CUPS specific stuff

$ipp->debug_level = 3; // Debugging very verbose

$ipp->setLog('/tmp/printipp','file',1); // logging almost quiet
$ipp->setLog('/tmp/printipp','file',2); // logging verbose
$ipp->setLog('/tmp/printipp','file',3); // logging very verbose

$ipp->setHost("localhost");
//$ipp->setHost("toto");// Resistance test
$ipp->setHost($host); //Put your printer IP or hostname/fqdn here

$ipp->setPrinterURI($printer_uri); // Set printer URI here
//$ipp->setPrinterURI("ipp://localhost:631/printers/epson"); // Set printer URI here
//$ipp->setPrinterURI("/printers/foo"); // => abort "client-error-not-found"

$ipp->setUserName("php IPP tester");

$ipp->setFidelity(); // printing abort if every attribute could not be set on printer. NOTE: CUPS do not abort :)

$ipp->setCharset('utf-8');
$ipp->setLanguage($language);

$ipp->setAuthentification($user,$password); // username & password 

$j = 0;
$test = 1;

/* printing string */

echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "Printing text string<br />";

$ipp->setData("This is a text string\n");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";


/* printing a large file */
/*
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setData("./testfiles/photo.jpg");
echo "Printing large file Job status: ".$ipp->printJob("epson")."<br />";


/* printing a postcript file */
/*
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setMimeMediaType(); // => autodetection
$ipp->setData("./testfiles/test.ps");
echo "Printing Postscript Job status: ".$ipp->printJob("epson")."<br />";


/* printing a png  file */
/*
echo "<br /><br /><br /> TEST ".$test ++."<br />";

echo "OPERATION ". $j ++ ."<br />";
$ipp->setData("./testfiles/test.png");
echo "Printing png Job status: ".$ipp->printJob("epson")."<br />";

/* printing RAW strings, no form feed */
/*
echo "<br /><br /><br /> TEST ".$test ++."<br />";

$ipp->setRawText();
$ipp->unsetFormFeed();

echo "Printing RAW TEXT strings<br />";

$ipp->setData("This is a RAW TEXT line\n");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is half a line ");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->setData("This is a end of line\n");
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";

// set copies to 2 (same sheet of paper: form feed is unset)
$ipp->setData("This lines must appeared twice\r\n");
$ipp->setCopies(2);
echo "OPERATION ". $j ++ ."<br />";
echo "Job status: ".$ipp->printJob("epson")."<br />";
$ipp->setCopies(1);

// printing string, then form feed
echo "OPERATION ". $j ++ ."<br />";
$ipp->setFormFeed();
$ipp->setData("End of test");
echo "Job status: ".$ipp->printJob("epson")."<br />";

$ipp->unsetRawText();


/**/

echo "END OF OPERATIONS <br /><br /><br />";

/* get informations about status */


echo "Operations status:\n" ; 
echo "<pre>\n";
print_r($ipp->status);
echo "</pre>";


/* get debugging informations */

echo "<h3>Debug</h3><pre>";
$ipp->printDebug();
echo "</pre>";


/* end of test */

echo "END OF TESTFILE</body></html>";
?>
