<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

require("include/header.inc");
require("include/dbconnect.php");

// Only people of the phpAuthent group 'edit' may submit the form
require_once(PHPMYMEMBERS_DIR . "/include/phpauthent/phpauthent_core.php");
$userlist = array("");
$grouplist = array("edit");


// We show a Javascript box when insert/update was
// successfully done on db within 'submit.php'.
if ( CONFIRM_DB_WRITES_WITH_POPUP == 'true' ) {
	if ($_REQUEST['status'] == 'ok') {
		echo "<script>alert(\"" . LANG_DATABASE_SUCCESS . "\")</script>";
	}
}

?>

<TABLE class='main'>
 <TR>
   <TD>

<?

// Find out which address we should display
$Adress_ID     	= (isset($_REQUEST['address']))  ?  $_REQUEST['address']  :  "1";
$address_table 	= "Adresse" . "$Adress_ID";
$action	       	= $_REQUEST['action'];
$date		= date("Y-m-d");

// Only query database if Mitglied_ID is selected, otherwise we are in 'new'
// mode and thus can't query anything yet which would produce mysql errors
if ( !empty($_REQUEST['Mitglied_ID']) ) {

	// Make life easier
	$Mitglied_ID = $_REQUEST['Mitglied_ID'];

	// Query main db table and set php variables; we do list all fields deliberatly
    // (instead of *) because we do NOT want to query the photo with lot's of kilobytes here
	$main_query     = sprintf("
			SELECT  m.Mitgliednummer,
                    m.Nachname,
                    m.Vorname, 
                    m.Geburtsdatum, 
                    m.Eintritt, 
                    m.Austritt, 
                    m.Mitgliedschaft_ID, 
                    s.Mitgliedschaft, 
                    m.Zivilstand_ID, 
                    z.Zivilstand, 
                    m.Geschlecht_ID, 
                    g.Geschlecht, 
                    m.Update, 
                    m.Beruf, 
                    m.Titel, 
                    m.GL 
            FROM `Mitglied` m, `Geschlecht` g, `Zivilstand` z, `Mitgliedschaft` s
			WHERE m.Mitglied_ID=%s
			and   m.Geschlecht_ID=g.Geschlecht_ID
			and   m.Mitgliedschaft_ID=s.Mitgliedschaft_ID
			and   m.Zivilstand_ID=z.Zivilstand_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($main_query,$db);
		$row    = mysql_fetch_array($result);

		$Mitgliednummer     = $row['Mitgliednummer'];
		$Nachname 	        = $row['Nachname'];
		$Vorname 	        = $row['Vorname'];
		$Geburtsdatum 	    = $row['Geburtsdatum'];
		$Eintritt 	        = $row['Eintritt'];
		$Austritt 	        = $row['Austritt'];
		$Mitgliedschaft_ID  = $row['Mitgliedschaft_ID'];
		$Mitgliedschaft     = $row['Mitgliedschaft'];
		$Zivilstand_ID	    = $row['Zivilstand_ID'];
		$Zivilstand	        = $row['Zivilstand'];
		$Geschlecht_ID	    = $row['Geschlecht_ID'];
		$Geschlecht	        = $row['Geschlecht'];
		$Update 	        = $row['Update'];
		$Beruf 		        = $row['Beruf'];
		$Titel 		        = $row['Titel'];
		$GL 		        = $row['GL'];

	// Query address db tables and set php variables
	// Not fetching anything again should be quicker
	$address_query	= sprintf("
			SELECT  m.Mitglied_ID,
                    a.Adressfeld1, 
                    a.Adressfeld2, 
                    a.Kanton, 
                    a.Postleitzahl,
			        a.Stadt, 
                    a.Land, 
                    a.Telephon, 
                    a.Telefax, 
                    a.Mobil, 
                    a.EMail, 
                    a.Mitglied_ID
		    FROM `Mitglied` m, `$address_table` a
			WHERE m.Mitglied_ID=%s
			and   m.Mitglied_ID=a.Mitglied_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($address_query,$db);
		$row    = mysql_fetch_array($result);

		$Adressfeld1    = $row['Adressfeld1'];
		$Adressfeld2    = $row['Adressfeld2'];
		$Kanton    	    = $row['Kanton'];
		$Postleitzahl   = $row['Postleitzahl'];
		$Stadt   	    = $row['Stadt'];
		$Land		    = $row['Land'];
		$Telephon    	= $row['Telephon'];
		$Telefax	    = $row['Telefax'];
		$Mobil		    = $row['Mobil'];
		$EMail		    = $row['EMail'];
} ?>

<NOSCRIPT><? echo LANG_NOJS ?></NOSCRIPT>
<SCRIPT TYPE="text/javascript">

<?
if ("$action" == 'new' or "$action" == 'edit') { ?>
    // Only script specific to this form goes here.
    // General-purpose routines are in a separate file.
      function validateOnSubmit() {
        var elem;
        var errs=0;
        var dderrs=0;

        // execute all element validations in reverse order,
        // so focus gets set to the first one in error.

        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Eintritt, 'inf_Eintritt')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_OCCUPATION == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Beruf, 'inf_Beruf')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Geburtsdatum, 'inf_Geburtsdatum')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_NUMBER == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Mitgliednummer, 'inf_Mitgliednummer')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_FORENAME == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Vorname, 'inf_Vorname')) errs += 1;
        <? } ?>
        <? if (MEMBER_FORM_MANDATORY_LASTNAME == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Nachname, 'inf_Nachname')) errs += 1;
        <? } ?>

        <? // Only validate fields of first and main address ?>
        <? if ($Adress_ID == '1') { ?>
            <? if (MEMBER_FORM_MANDATORY_COUNTRY == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Land, 'inf_Land')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_CITY == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Stadt, 'inf_Stadt')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_POSTAL_CODE == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Postleitzahl, 'inf_Postleitzahl')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_ADDRESS1 == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Adressfeld1, 'inf_Adressfeld1')) errs += 1;
            <? } ?>
            <? if (MEMBER_FORM_MANDATORY_ADDRESS2 == 'true') { ?>
                if (!validatePresent(document.forms.membercard.Adressfeld2, 'inf_Adressfeld2')) errs += 1;
            <? } ?>
        <? } ?>

        <? // validate drop downs too - FIXIT: don't know to generate the red stars here...
           // That's why we workaround by displaying a separate alert message ?>

        <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP == 'true') { ?>
                if ( document.forms.membercard.Mitgliedschaft.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        <? if (MEMBER_FORM_MANDATORY_CIVILSTATE == 'true') { ?>
                if ( document.forms.membercard.Zivilstand.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        <? if (MEMBER_FORM_MANDATORY_SEX == 'true') { ?>
                if ( document.forms.membercard.Geschlecht.selectedIndex == 0 ) dderrs +=1;
        <? } ?>

        if (errs>1) alert('<? echo LANG_MULTI_INPUT_ERR ?>');
        if (errs==1) alert('<? echo LANG_SINGLE_INPUT_ERR ?>');

        if (dderrs>1) { alert('<? echo LANG_MULTI_DROPDOWN_ERR ?>'); errs=1; }
        if (dderrs==1) { alert('<? echo LANG_SINGLE_DROPDOWN_ERR ?>'); errs=1; }

        return (errs==0);
      };

<? } else { ?>

    <!--
    // www.web-toolbox.net , W. Jansen
    // Als Übergabeparameter wird die bildquelle,breite und höhe übergeben
    // hand over parameters for source,width and height

    function FotoWindow(bildurl,b,h)
    {
    var eigenschaften,sbreite,shoehe,fenster,b,h;

    // stellt die Bildschirmabmessungen fest
    // find window size
    var ns6 = (!document.all && document.getElementById);
    var ie4 = (document.all);
    var ns4 = (document.layers);

    if(ns6||ns4) {
    sbreite = innerWidth;
    shoehe = innerHeight;
    }
    else if(ie4) {
    sbreite = document.body.clientWidth;
    shoehe = document.body.clientHeight;
    }

    x = (sbreite-b)/2;
    y = (shoehe-h)/2;

    eigenschaften="left="+x+",top="+y+",screenX="+x+",screenY="+y+",width="+b+",height="+h+",menubar=no,toolbar=no,statusbar=0";

    fenster=window.open("","",eigenschaften);
    fenster.focus();
    fenster.document.open();
    with (fenster) {
      document.write("<html><head>");
      // geändert 2004 für Mozilla
      document.write('<scr' + 'ipt type="text/javascr' + 'ipt" language="JavaScr' + 'ipt">');
      // bei click  schliessen , on click close
      document.write("function click() { window.close(); } ");
      document.write("document.onmousedown=click ");
      // geändert 2004 für Mozilla
      document.write('</scr' + 'ipt>');
      document.write("<title>klick to close</title></head>");
      // bei Focusverlust schliessen, close if window looses focus
      // Zeile geändert Aug 2003 (Dreamweaver machte Probleme)
      document.write("<" + "body onblur='window.close()';");
      document.write("marginwidth='0' marginheight='0' leftmargin='0' topmargin='0'>");
      document.write("<center>");
      document.write("<img src='"+ bildurl +"' border='0'>");
      document.write("<center>");
      document.write("</body></html>");
      fenster.document.close();
    }
    }
    //-->

<? } ?>
</SCRIPT>

<?
// Routine for UPLOADING the picture. Code for displaying the
// picture can be found in include/showimage.php
if ($_POST['completed'] == 1) {
        // Generate a secure temp file name
        srand ((double)microtime()*1000003);
        $tempfile = UPLOAD_TMP_DIR . '/' . rand() . '.phpmm';
        //print_r("$tempfile");
        move_uploaded_file($_FILES['imagefile']['tmp_name'],"$tempfile");
        $instr = fopen("$tempfile",'rb');
        $image = addslashes(fread($instr,filesize("$tempfile")));
        if (strlen($instr) < MAX_UPLOAD_SIZE) {
                mysql_query("UPDATE `Mitglied` SET `Photo`= \"$image\" WHERE `Mitglied_ID`='$Mitglied_ID'");
        }
        unlink("$tempfile");
}
?>


<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='5' CELLSPACING='10' width="800">
    <TR>
        <TH>
          <TABLE BORDER='0' WIDTH='100%' CELLPADDING='0' CELLSPACING='0'>
           <TR>
            <TD class='titel_hinweis'>
            <?
            switch($action) {
            case "edit":
                    echo LANG_EDIT_EXISTING_RECORD;
                    break;
            case "new":
                    echo LANG_CREATE_NEW_RECORD;
                    break;
            default:
                    echo LANG_VIEW_DETAILS;
                    break;
            }
            ?>
            </TD>
            <TD align='right'>
            <? // Only make an IMG link if not in edit or new mode
            if ("$action" != 'new' and "$action" != 'edit') { ?>
                <A HREF="javascript:FotoWindow('include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>','550','450')">
                    <img class='showimage' title='<? echo LANG_FULLSIZE ?>' src=include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>>
                </A>
            <? } elseif ("$action" == 'edit') { ?>
                    <img class='showimage' src=include/showimage.php?Mitglied_ID=<? echo "$Mitglied_ID" ?>>
            <? } ?>
            </TD>
           </TR>
          </TABLE>
        </TH>
            <? if ("$action" != 'new' and "$action" != 'edit') { 
        ?><TD align='right' valign='top'><?
                    $prev = getNeighbourMemberID($Nachname,$Vorname,$Eintritt,$Mitglied_ID,prev);
                    $next = getNeighbourMemberID($Nachname,$Vorname,$Eintritt,$Mitglied_ID,next);
                if (!empty($prev)) { ?>
                    <A HREF='<? echo "$_SERVER[PHP_SELF]?Mitglied_ID=$prev&address=$Adress_ID" ?>'>
                        <IMG TITLE='<? echo LANG_BACK ?>' BORDER='0' SRC='img/leftarrow.png'>
                    </A>
                <? }
                if (!empty($next)) { ?>
                    <A HREF='<? echo "$_SERVER[PHP_SELF]?Mitglied_ID=$next&address=$Adress_ID" ?>'>
                        <IMG TITLE='<? echo LANG_NEXT ?>' BORDER='0' SRC='img/rightarrow.png'>
                    </A>
                <? }
            } elseif ("$action" == 'edit') {
        ?><TD align='left' valign='top'>
                <form enctype=multipart/form-data method=post>
                    <input type=hidden name=MAX_FILE_SIZE value=<? echo MAX_UPLOAD_SIZE ?>>
                    <input type=hidden name=completed value=1>
                    <input type=file name=imagefile>
                    <input type=submit value="Bild <? echo strtolower(LANG_SAVE) ?>">
                </form>
            <? } ?>
        </TD>
    </TR>
    <TR>
        <TD VALIGN='top'>
        <? // Output of the member data table (left side) ?>
        <TABLE BORDER='0' bgcolor='#EEEEEE' CELLPADDING='3' CELLSPACING='5' HEIGHT='400'>
        <TR>
            <TD colspan='3'>
        	<TABLE WIDTH='100%' BORDER='0'>
	            <TR VALIGN='bottom'>
                    <TD>
<?
			switch($action) {
			case "new":
 			case "edit":
                    ?>
                    <FORM NAME='membercard' method='POST' onsubmit="return validateOnSubmit()" action='submit.php'>
                     <TABLE border='0'>
                      <TR><TD>&nbsp;</TD><TD><? echo LANG_LASTNAME ?></TD><TD>&nbsp;</TD><TD><? echo LANG_FORENAME ?></TD></TR>
                      <TR>
                        <TD ID="inf_Nachname">&nbsp;</TD>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='Nachname'
                            ID='Nachname'
                            <? if (MEMBER_FORM_MANDATORY_LASTNAME == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_Nachname');"
                            <? } ?>
                            maxlength='49'
                            VALUE='<? if (!empty($Nachname)) echo $Nachname ?>'>
                        </INPUT>
                       </TD>
                        <TD ID="inf_Vorname">&nbsp;</TD>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='Vorname'
                            ID='Vorname'
                            <? if (MEMBER_FORM_MANDATORY_FORENAME == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_Vorname');"
                            <? } ?>
                            maxlength='49'
                            VALUE='<? if (!empty($Vorname)) echo $Vorname ?>'>
                        </INPUT>
                       </TD>
                      </TR>
                     </TABLE>
                    <?
			        break;
			default:
			        echo "$Nachname $Vorname";
                    break;
			}
            ?>
		    </TD>
        </TR>
	    <TR VALIGN='top'><TD><HR></TD></TR>
    </TABLE>
    </TD></TR>

        <? // Let's output the membership number field ?>
        <TR>    
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_NUMBER ?>:</TD>
            <TD ID="inf_Mitgliednummer">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Mitgliednummer'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Mitgliednummer'
                                ID='Mitgliednummer'
                                <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_NUMBER == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Mitgliednummer');"
                                <? } ?>
                                MAXLENGTH='6'
                                VALUE='<? if (isset($Mitgliednummer)) echo $Mitgliednummer ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Mitgliednummer";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the title field
        if (constant('MEMBER_FORM_SHOW_TITLE') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBER_TITLE ?>:</TD>
            <TD ID="inf_Titel">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Titel'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Titel'
                                ID='Titel'
                                <? if (MEMBER_FORM_MANDATORY_TITLE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Titel');"
                                <? } ?>
                                MAXLENGTH='6'
                                VALUE='<? if (!empty($Titel)) echo $Titel ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Titel";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the birth date field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_DATE_OF_BIRTH ?>:</TD>
            <TD ID="inf_Geburtsdatum">&nbsp;</TD>
		    <TD class='detail_view_conts'><?
			    switch($action) {
                case 'edit':
                    require_once("include/datepicker.php"); ?>
                    <INPUT
                        NAME='Geburtsdatum'
                        id='DPC_Geburtsdatum'
                        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                        ONCHANGE="validatePresent(this, 'inf_Geburtsdatum');"
                        <? } ?>
                        VALUE='<? echo ( $Geburtsdatum != '0000-00-00' ) ? make_nice_date("$Geburtsdatum") : '' ?>'>
                    </INPUT><?
                    break;
                case 'new':
                    require_once("include/datepicker.php"); ?>
                    <INPUT
                        NAME='Geburtsdatum'
                        id='DPC_Geburtsdatum'
                        <? if (MEMBER_FORM_MANDATORY_DATE_OF_BIRTH == 'true') { ?>
                        ONCHANGE="validatePresent(this, 'inf_Geburtsdatum');"
                        <? } ?>
                        VALUE=''>
                    </INPUT><?
                    break;
                default:
                    echo ( $Geburtsdatum != '0000-00-00' ) ? make_nice_date("$Geburtsdatum") : LANG_UNKNOWN;
                } ?>
            </TD>
        </TR>

        <? // Let's output the title field
        if (constant('MEMBER_FORM_SHOW_OCCUPATION') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_OCCUPATION ?>:</TD>
            <TD ID="inf_Beruf">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Beruf'><?
                    switch($action) {
                    case "new":
                    case "edit": ?>
                        <INPUT
                            NAME='Beruf'
                            ID='Beruf'
                            <? if (MEMBER_FORM_MANDATORY_OCCUPATION == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_Beruf');"
                            <? } ?>
                            MAXLENGTH='49'
                            VALUE='<? if (!empty($Beruf)) echo $Beruf ?>'>
                        </INPUT><?
                        break;
                    default:
                        echo "$Beruf";
                        break;
                    } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the membership start field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_START ?>:</TD>
            <TD ID="inf_Eintritt">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Eintritt'
                            id='DPC_Eintritt'
                            <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_Eintritt');"
                            <? } ?>
                            VALUE='<? echo make_nice_date("$Eintritt") ?>'>
                        </INPUT><?
				        break;
                    case 'new':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Eintritt'
                            id='DPC_Eintritt'
                            <? if (MEMBER_FORM_MANDATORY_MEMBERSHIP_START == 'true') { ?>
                            ONCHANGE="validatePresent(this, 'inf_Eintritt');"
                            <? } ?>
                            VALUE='<? echo make_nice_date("$date") ?>'>
                        </INPUT><?
				        break;
                    default:
                        echo make_nice_date("$Eintritt");
                        break;
                    } ?>
            </TD>
        </TR>

        <? // Let's output the membership end field
        if ("$action" != 'new') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_END ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Austritt'
                            id='DPC_Austritt'
                            VALUE='<? echo ( $Austritt != '0000-00-00' ) ? make_nice_date("$Austritt") : '' ?>'>
                        </INPUT> <?
                        break;
                    default:
                        echo ( $Austritt != '0000-00-00' ) ? make_nice_date("$Austritt") : '';
                        break;
                    } ?>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the membership type field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP ?>:</TD>
            <TD ID="inf_Mitgliedschaft_ID">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) { ?>
                                    <OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    case 'new':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                		        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    // Don't show alumni group on 'new'
                                    if ( $row['Mitgliedschaft'] == 'MEMBERSHIP_ALUMNI' ) { continue; }
                                    ?><OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Mitgliedschaft");
                        break;
			        } ?>
                </SELECT>
            </TD>
        </TR>

        <? // Let's output the civil status field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_CIVIL_STATUS ?>:</TD>
            <TD ID="inf_Zivilstand_ID">&nbsp;</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case "edit":
                    case "new":
                        $result = get_dropdown('Zivilstand'); ?>
                        <SELECT NAME='Zivilstand_ID' ID='Zivilstand'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Zivilstand_ID'] == "$Zivilstand_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Zivilstand_ID]'>" . constant("$row[Zivilstand]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Zivilstand");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's have sex ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SEX ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
			        case "edit":
			        case "new":
                        $result = get_dropdown('Geschlecht'); ?>
                        <SELECT NAME='Geschlecht_ID' ID='Geschlecht'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Geschlecht_ID'] == "$Geschlecht_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Geschlecht_ID]'>" . constant("$row[Geschlecht]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Geschlecht");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's output the specific yes/no question ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SPECIFIC_YESNO ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><?
                switch($action) {
                case 'edit': ?>
			    	<SELECT NAME='GL'><?
			    	    foreach (range('0','1') as $line) {
                            ?><OPTION<?
				                if ( "$line" == "$GL" ) { echo ' SELECTED '; }
				                echo " VALUE='$line'>";
				                echo ("$line" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
				            ?></OPTION><?
			     	    } ?>
                    </SELECT><?
                    break;
                case "new": ?>
                    <SELECT NAME='GL'><?
                        foreach (range('0','1') as $line) {
                            ?><OPTION<?
                                if ( "$line" == 1 ) { echo ' SELECTED '; }
                                echo " VALUE='$line'>";
                                echo ("$line" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
                            ?></OPTION><?
                        } ?>
                    </SELECT><?
                    break;
                default:
                    echo ("$GL" == 1) ? strtolower(LANG_YES) : strtolower(LANG_NO);
                    break;
                } ?>
            </TD>
        </TR>

    <? // Let's output the update field ?><?
    switch($action) {
    case "edit":
    case "new":
        break;
    default: ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_LAST_UPDATE ?>:</TD>
            <TD></TD>
            <TD class='detail_view_conts'><? echo make_nice_date("$Update") .' / '. getUpdatedBy("$Mitglied_ID"); ?></TD>
        </TR><?
	  } ?>


	</TABLE>
    </TD>

    <? // Output of the address table ?>
    <TD VALIGN='top'>
    <TABLE BORDER='0' bgcolor='#EEEEEE' CELLPADDING='3' CELLSPACING='5' HEIGHT='400'>
        <TR><TD colspan='3'>
            <TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>
	            <TR ALIGN='right' VALIGN='bottom'>
                <?		
                // Do not show header hyperlink if already selected.
                // uses a function to count number of address tables
                // People may just add another table 'Adresse..' to use it
                // If in 'edit' or 'new' mode the links disappear for usability
                // and protection
                $number_address_tables = get_table_number('Adresse');
                foreach (range('1', "$number_address_tables") as $num) {
                    if ($Adress_ID != $num ) {
                         echo "<TD BGCOLOR='lightgrey'>";
                         switch($action) {
                         case "edit":
                         case "new":
                           echo "$num. " . LANG_ADRESS;
                           break;
                         default:
                           echo "<A HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$num'>$num. " . LANG_ADRESS . "</A>";
                         }
                         echo "</TD>\n";	
                    } else {
                         echo "<TD BGCOLOR='#EEEEEE'><FONT COLOR='green'>$num. " . LANG_ADRESS . "</FONT></TD>\n";	
                    }
                }
                ?>
	            </TR>
		        <TR VALIGN='top'>
                    <TD COLSPAN='<? echo $number_address_tables ?>'><HR></TD>
                </TR>
            </TABLE>
	    </TD></TR>

        <? // Let's output the address field number one ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?> 1:</TD>
            <TD ID="inf_Adressfeld1">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Adressfeld1'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Adressfeld1'
                                ID='Adressfeld1'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_ADDRESS1 == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Adressfeld1');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Adressfeld1)) echo $Adressfeld1 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Adressfeld1";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the address field number two ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?> 2:</TD>
            <TD ID="inf_Adressfeld2">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Adressfeld2'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Adressfeld2'
                                ID='Adressfeld2'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_ADDRESS2 == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Adressfeld2');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Adressfeld2)) echo $Adressfeld2 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Adressfeld2";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the state field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_STATE ?>:</TD>
            <TD ID="inf_Kanton">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Kanton'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Kanton'
                                ID='Kanton'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_STATE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Kanton');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Kanton)) echo $Kanton ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Kanton";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the postal code field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_POSTAL_CODE ?>:</TD>
            <TD ID="inf_Postleitzahl">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Postleitzahl'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Postleitzahl'
                                ID='Postleitzahl'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_POSTAL_CODE == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Postleitzahl');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Postleitzahl)) echo $Postleitzahl ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Postleitzahl";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the city field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_CITY ?>:</TD>
            <TD ID="inf_Stadt">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Stadt'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Stadt'
                                ID='Stadt'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_CITY == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Stadt');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Stadt)) echo $Stadt ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Stadt";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the country field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_COUNTRY ?>:</TD>
            <TD ID="inf_Land">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Land'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Land'
                                ID='Land'
                                <? if ($Adress_ID == '1' and MEMBER_FORM_MANDATORY_COUNTRY == 'true') { ?>
                                ONCHANGE="validatePresent(this, 'inf_Land');"
                                <? } ?>
                                MAXLENGTH='<? echo LABEL_WIDTH_CHAR ?>'
                                VALUE='<? if (!empty($Land)) echo $Land ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Land";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>

        <? // Let's output the phone number field
        if (constant('MEMBER_FORM_SHOW_PHONE') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_PHONE ?>:</TD>
            <TD ID="inf_Telephon">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Telephon'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Telephon'
                                ID='Telephon'
                                ONCHANGE="validateTelnr(this, 'inf_Telephon', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($Telephon)) echo $Telephon ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Telephon";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the fax number field
        if (constant('MEMBER_FORM_SHOW_FAX') == 'true') { ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_FAX ?>:</TD>
            <TD ID="inf_Telefax">&nbsp;</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Telefax'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Telefax'
                                ID='Telefax'
                                ONCHANGE="validateTelnr(this, 'inf_Telefax', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($Telefax)) echo $Telefax ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Telefax";
                            break;
                        } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the mobile number field
        if (constant('MEMBER_FORM_SHOW_CELLPHONE') == 'true') { ?>
	    <TR>
            <TD class='detail_view_entry'><? echo LANG_CELLPHONE ?>:</TD>
            <TD ID="inf_Mobil">&nbsp;</TD>
		    <TD class='detail_view_conts'>
                <LABEL FOR='Mobil'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                        	<INPUT
                                NAME='Mobil'
                                ID='Mobil'
                                ONCHANGE="validateTelnr(this, 'inf_Mobil', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($Mobil)) echo $Mobil ?>'>
                            </INPUT> <?
		    		        break;
			            default:
                            echo "$Mobil";
                            break;
			            } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>

        <? // Let's output the email field
        if (constant('MEMBER_FORM_SHOW_EMAIL') == 'true') { ?>
	    <TR>
            <TD CLASS='detail_view_entry'><? echo LANG_EMAIL ?>:</TD>
            <TD ID="inf_EMail">&nbsp;</TD>
		    <TD CLASS='detail_view_conts'>
                <LABEL FOR='EMail'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='EMail' 
                                ID='EMail'
                                ONCHANGE="validateEmail(this, 'inf_EMail', false);"
                                MAXLENGTH='50'
                                VALUE='<? if (!empty($EMail)) echo $EMail ?>'>
                            </INPUT> <?
				            break;
                        default: ?>
                            <A CLASS='nolink' HREF='mailto:<? echo $EMail ?>'><? echo $EMail ?></A> <?
                            break;
			            } ?>
                </LABEL>
            </TD>
        </TR>
        <? } ?>
      </TABLE>

      <TABLE WIDTH='99%' BORDER='0'>
        <TR><TD COLSPAN='3'><HR></TD></TR>
        <TR><TD COLSPAN='3' align='right'>
<?    
    switch($action) {
    case "edit":
        if (isEnabled($userlist,$grouplist)) { ?>
                <INPUT TYPE='hidden' name='action' value='edit'>
                <INPUT TYPE='hidden' name='Mitglied_ID' value='<? echo $Mitglied_ID ?>'>
                <INPUT TYPE='hidden' name='Adress_ID' value='<? echo $Adress_ID ?>'>
                <INPUT TYPE='button' value='<? echo LANG_BACK ?>' onclick=history.go(-1)>
                <INPUT TYPE='submit' value='<? echo LANG_SAVE ?>'>
        <? } ?>
        </TD></TR></FORM><?
		break;
	  case "new":
        if (isEnabled($userlist,$grouplist)) { ?>
		    <INPUT TYPE='hidden' name='action' value='new'>
		    <INPUT TYPE='hidden' name='Mitglied_ID' value='<? echo $Mitglied_ID ?>'>
		    <INPUT TYPE='hidden' name='Adress_ID' value='<? echo $Adress_ID ?>'>
		    <INPUT TYPE='button' value='<? echo LANG_BACK ?>' onclick=history.go(-1)>
		    <INPUT TYPE='submit' value='<? echo LANG_SAVE ?>'>
        <? } ?>
		</TD></TR></FORM><?
		break;
	  default:	
	        echo "| <A class='normal' HREF='print.php?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=detail'>" . LANG_GENERATE_LABEL_PDF . "</A> ";
            if (isEnabled($userlist,$grouplist)) {
	            echo "| <A class='normal' HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=edit'>" . LANG_UPDATE . "</A> ";
            } ?>
       |</TD></TR>
	  <? } ?>
            </TABLE>

            </TD>
        </TR>
    </TABLE>


  </TD>
 </TR>
</TABLE>

<?  include("include/footer.inc"); ?>
