<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include("include/header.inc");
include("include/dbconnect.php");

// This page handles three output formats, AZ, search and dropdown list
$action = $_REQUEST['action'];
if (empty($action) ) { $action = "dropdown"; }
?>

<TABLE class='main'>

<?
// az and dropdown sql queries start similary; we name it $base_query
// and concatenate the rest depending on the user selection later.
$alumni_id =   get_field_id_by_descr('MEMBERSHIP_ALUMNI','Mitgliedschaft');
$base_query = "SELECT m.Mitglied_ID, m.Nachname, m.Vorname, m.Mitgliednummer, a.Land
	       FROM Mitglied m, Adresse1 a
	       WHERE m.Mitglied_ID=a.Mitglied_ID";


switch($action) {
case "search":
?>
  <TR><TH><? echo LANG_SEARCH ?></TH></TR>
  <TR>
<?
	if ( !empty($_REQUEST['term']) ) { 

		$term = $_REQUEST['term'];

        	$query  = "SELECT DISTINCT m.`Mitglied_ID`, m.`Mitgliednummer`, m.`Nachname`, m.`Vorname`, a.`Land`
			   FROM `Mitglied` m, `Mitgliedschaft` z, `Adresse1` a
			   WHERE m.`Mitglied_ID`       = a.`Mitglied_ID`
			   AND   m.`Mitgliedschaft_ID` = z.`Mitgliedschaft_ID`
        	   	   AND (
				   m.`Mitglied_ID` LIKE '%$term%'
                 	   	OR m.`Mitgliednummer` LIKE '%$term%'
               	 	   	OR m.`Nachname` LIKE '%$term%'
               		   	OR m.`Vorname` LIKE '%$term%'
               	   		OR m.`Austritt` LIKE '%" . make_mysql_date($term) . "%'
               	   		OR m.`Eintritt` LIKE '%" . make_mysql_date($term) . "%'
         	       	   	OR m.`Beruf` LIKE '%$term%'
				
				OR a.`Adressfeld1` LIKE '%$term%'
				OR a.`Adressfeld2` LIKE '%$term%'
				OR a.`Kanton` LIKE '%$term%'
				OR a.`Postleitzahl` LIKE '%$term%'
				OR a.`Stadt` LIKE '%$term%'
				OR a.`Land` LIKE '%$term%'
				OR a.`Telephon` LIKE '%$term%'
				OR a.`Telefax` LIKE '%$term%'
				OR a.`Mobil` LIKE '%$term%'
				OR a.`EMail` LIKE '%$term%'
			)";

		if ( ($_REQUEST['include_alumni'] != 'on' ) ) {
			$query .= " AND z.`Mitgliedschaft` != 'MEMBERSHIP_ALUMNI'";
		}
	}
?>

        <form method="POST" action="<? $_SERVER['PHP_SELF'] ?>">
    	 <TD class='boxed'>
          <table border="0" cellspacing="2">
            <tr>
              <td><? echo LANG_SPECIFY_SEARCH_TERM ?></td>
              <td></td>
            </tr>
	    <tr>
	    </tr>
            <tr>
              <td valign="top"><input type="text" name="term" value="<? $term ?>" size="35"></TD>
              <td valign="top"><input type="checkbox" name="include_alumni"
		<? 
		echo ($_REQUEST['include_alumni'] == 'on') ? ' checked' : ' unchecked';
		echo '>' . LANG_INCLUDE_ALUMNI;
		?>
	     </td>
            </tr>
            <tr>
              <td align='right'><input type="submit" value="<? echo LANG_NEXT ?>"></td>
              <td></td>
            </tr>
          </table>
        </form>

<?
	// Now we remember the generated URI
	$baselink = $_SERVER['PHP_SELF'] . "?action=search&exclude_alumni=" . $_REQUEST['exclude_alumni'] . "&term=" . $term . "&orderby=";

	break;


case "dropdown":

	?>
	<TR><TH><? echo LANG_LIST ?></TH></TR>
	<TR>
   	<FORM method='POST' action="<? $_SERVER['PHP_SELF'] ?>">
    	 <TD class='boxed'>
	<?

	$Mitgliedschaft_ID = $_REQUEST['Mitgliedschaft_ID'];
	if (empty($Mitgliedschaft_ID) ) { $Mitgliedschaft_ID = "none"; }

	// Creating drop down list from database
	$result = get_dropdown('Mitgliedschaft');
	echo "\t\t\t<SELECT NAME='Mitgliedschaft_ID'>\n";
		echo "\t\t\t<OPTION VALUE='none'>" . LANG_PLEASE_CHOOSE . "</OPTION>\n";
		while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
		    echo "\t\t\t<OPTION";
                    if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo " SELECTED"; }
		    echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]") . "</OPTION>\n";
		}
	echo "\t\t\t</SELECT>\n";
        echo "\t\t<INPUT TYPE='submit' value='" . LANG_NEXT . "'>\n";

	switch($Mitgliedschaft_ID) {
	case "none":
		break;
	case "all":
		$query = $base_query . sprintf(" AND m.Mitgliedschaft_ID!=%s", quote_smart($alumni_id));
		break;
	default:
		$query = $base_query . sprintf(" AND m.Mitgliedschaft_ID=%s", quote_smart($Mitgliedschaft_ID));
	}

	?> </FORM> <?
	// Now we remember the generated URI
	$baselink = $_SERVER['PHP_SELF'] . "?action=dropdown&Mitgliedschaft_ID=" . $Mitgliedschaft_ID . "&orderby=";

	break;


case "az":

        echo "<TR><TH>" . LANG_AZ . "</TH></TR>";

	$list = $_REQUEST['list'];

    	echo "<TD class='boxed'> | ";
        foreach (range('A', 'Z') as $letter) {
                echo "<A HREF='" . $_SERVER['PHP_SELF'] . "?action=az&list=$letter'>$letter</A> | \n";
        }
	if (!empty($_REQUEST['list']) ) {
        	$query = $base_query . sprintf(" AND m.Mitgliedschaft_ID!=%s
						 AND LEFT(Nachname,1)=%s",
						quote_smart($alumni_id),
						quote_smart($list));
	}
	// Now we remember the generated URI
	$baselink = $_SERVER['PHP_SELF'] . "?action=az&list=" . $list . "&orderby=";

	break;
}

?>
   </TD>
   <TD>
    <IMG SRC='img/<? echo $action ?>.png'>
   </TD>
 </TR>
 <TR>
   <TD>
<?

// Only execute query and display contents if there
// has been one generated further above
if (!empty($query)) {

	// let's see how we should order the results
	switch($_REQUEST['orderby']) {
	case "Vorname":
		$query .= " ORDER BY `Vorname`;";
		break;
	case "Land":
		$query .= " ORDER BY `Land`;";
		break;
	case "Mitgliednummer":
		$query .= " ORDER BY `Mitgliednummer`;";
		break;
	default:
		$query .= " ORDER BY `Nachname`;";
	}

	$result = mysql_query($query,$db);
	$num    = mysql_num_rows($result);

	if ($num > 0 ) {
		echo "<TABLE BORDER='0' CELLPADDING='2' WIDTH='99%'>\n";
		echo "  <TR>";
		  echo "\t<TD class='subheader'><A HREF='" . $baselink . "Nachname'>" . LANG_LASTNAME . "</A></TD>\n";
		  echo "\t<TD class='subheader'><A HREF='" . $baselink . "Vorname'>" . LANG_FORENAME . "</A></TD>\n";
		  echo "\t<TD class='subheader'><A HREF='" . $baselink . "Land'>" . LANG_COUNTRY . "</A></TD>\n";
		  echo "\t<TD class='subheader'><A HREF='" . $baselink . "Mitgliednummer'>" . LANG_MEMBERSHIP_NUMBER . "</A></TD>\n";
		  echo "\t<TD class='subheader'>" . LANG_AVAILABLE_FUNCTIONS . "</TD>\n";
		echo "</TR>\n";

		// Loop through all results and display
		$color = 2;
		while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
		   if ( $color == "1" ) {
			echo "\t<tr>\n";
			$color = 2;
		   } else {
			echo "\t<tr class='boxed'>\n";
			$color = 1;
		   }

		   echo "\t<TD class='result'>" . htmlspecialchars($row['Nachname']) . "</TD>";
		   echo "\t<TD class='result'>" . htmlspecialchars($row['Vorname']) . "</TD>";
		   echo "\t<TD class='result'>" . htmlspecialchars($row['Land']) . "</TD>";
		   echo "\t<TD class='result'>" . htmlspecialchars($row['Mitgliednummer']) . "</TD>";
/*		   echo "\t<TD> <a class=warn href='delete.php?Mitglied_ID=$row[Mitglied_ID]'
				onClick=\"return confirm('Wirklich unwiderruflich l&ouml;schen?')\">
				L&ouml;schen</a>&nbsp;
*/
		   echo "\t<TD class='result'><A href='print.php?Mitglied_ID=$row[Mitglied_ID]'>" . LANG_GENERATE_LABEL_PDF . "</A>\n";
		   echo "\t&nbsp;<A href='detail.php?Mitglied_ID=$row[Mitglied_ID]'>" . LANG_VIEW_DETAILS . "</A></TD>\n";
		   echo "\t</TR>\n";
		}
		echo "</TABLE>";

	// If $query set but empty result => print 'sorry' 
	} else {
?>
        	<TABLE BORDER='0' CELLPADDING='2' WIDTH='99%'>
        	  <TR><TD class='warn'><? echo LANG_NO_DATA_TO_DISPLAY ?></TD></TR>
        	</TABLE>
<?
	}
}
//echo "$query";
?>

   </TD>
 </TR>
</TABLE>

<?
include("include/footer.inc");
?>
