<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

require("include/header.inc");
require("include/dbconnect.php");

// Only people of the phpAuthent group 'edit' may submit the form
require_once(PHPMYMEMBERS_DIR . "/include/phpauthent/phpauthent_core.php");
$userlist = array("");
$grouplist = array("edit");


// We show a Javascript box when insert/update was
// successfully done on db within 'submit.php'.
if ( CONFIRM_DB_WRITES_WITH_POPUP == 'true' ) {
	if ($_REQUEST['status'] == 'ok') {
		echo "<script>alert(\"" . LANG_DATABASE_SUCCESS . "\")</script>";
	}
}

?>

<TABLE class='main'>
 <TR>
   <TD>

<?

// Find out which address we should display
$Adress_ID     	= (isset($_REQUEST['address']))  ?  $_REQUEST['address']  :  "1";
$address_table 	= "Adresse" . "$Adress_ID";
$action	       	= $_REQUEST['action'];
$date		= date("Y-m-d");

// Only query database if Mitglied_ID is selected, otherwise we are in 'new'
// mode and thus can't query anything yet which would produce mysql errors
if ( !empty($_REQUEST['Mitglied_ID']) ) {

	// Make life easier
	$Mitglied_ID = $_REQUEST['Mitglied_ID'];

	// Query main db table and set php variables
	$main_query     = sprintf("
			SELECT * FROM `Mitglied` m, `Geschlecht` g, `Zivilstand` z, `Mitgliedschaft` s
			WHERE m.Mitglied_ID=%s
			and   m.Geschlecht_ID=g.Geschlecht_ID
			and   m.Mitgliedschaft_ID=s.Mitgliedschaft_ID
			and   m.Zivilstand_ID=z.Zivilstand_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($main_query,$db);
		$row    = mysql_fetch_array($result);

		$Mitgliednummer     = $row['Mitgliednummer'];
		$Nachname 	        = $row['Nachname'];
		$Vorname 	        = $row['Vorname'];
		$Geburtsdatum 	    = $row['Geburtsdatum'];
		$Eintritt 	        = $row['Eintritt'];
		$Austritt 	        = $row['Austritt'];
		$Mitgliedschaft_ID  = $row['Mitgliedschaft_ID'];
		$Mitgliedschaft     = $row['Mitgliedschaft'];
		$Zivilstand_ID	    = $row['Zivilstand_ID'];
		$Zivilstand	        = $row['Zivilstand'];
		$Geschlecht_ID	    = $row['Geschlecht_ID'];
		$Geschlecht	        = $row['Geschlecht'];
		$Update 	        = $row['Update'];
		$Beruf 		        = $row['Beruf'];
		$Titel 		        = $row['Titel'];
		$GL 		        = $row['GL'];

	// Query address db tables and set php variables
	// Not fetching anything again should be quicker
	$address_query	= sprintf("
			SELECT m.Mitglied_ID, a.Adressfeld1, a.Adressfeld2, a.Kanton, a.Postleitzahl,
			       a.Stadt, a.Land, a.Telephon, a.Telefax, a.Mobil, a.EMail, a.Mitglied_ID
		        FROM `Mitglied` m, `$address_table` a
			WHERE m.Mitglied_ID=%s
			and   m.Mitglied_ID=a.Mitglied_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($address_query,$db);
		$row    = mysql_fetch_array($result);

		$Adressfeld1    = $row['Adressfeld1'];
		$Adressfeld2    = $row['Adressfeld2'];
		$Kanton    	    = $row['Kanton'];
		$Postleitzahl   = $row['Postleitzahl'];
		$Stadt   	    = $row['Stadt'];
		$Land		    = $row['Land'];
		$Telephon    	= $row['Telephon'];
		$Telefax	    = $row['Telefax'];
		$Mobil		    = $row['Mobil'];
		$EMail		    = $row['EMail'];
}
?>

<NOSCRIPT><? echo LANG_NOJS ?></NOSCRIPT>
<SCRIPT TYPE="text/javascript">
// Only script specific to this form goes here.
// General-purpose routines are in a separate file.
  function validateOnSubmit() {
    var elem;
    var errs=0;
    var dderrs=0;

    // execute all element validations in reverse order,
    // so focus gets set to the first one in error.

    //if (!validateTelnr  (document.forms.membercard.telnr, 'inf_telnr', true)) errs += 1;
    if (!validatePresent(document.forms.membercard.Mitgliednummer, 'inf_Mitgliednummer')) errs += 1;
    if (!validatePresent(document.forms.membercard.Vorname, 'inf_Vorname')) errs += 1;
    if (!validatePresent(document.forms.membercard.Nachname, 'inf_Nachname')) errs += 1;

    <? // Only validate fields of first and main address ?>
    <? if ($Adress_ID == '1') { ?>
        if (!validatePresent(document.forms.membercard.Land, 'inf_Land')) errs += 1;
        if (!validatePresent(document.forms.membercard.Stadt, 'inf_Stadt')) errs += 1;
        if (!validatePresent(document.forms.membercard.Postleitzahl, 'inf_Postleitzahl')) errs += 1;
        if (!validatePresent(document.forms.membercard.Adressfeld1, 'inf_Adressfeld1')) errs += 1;
    <? } ?>

    <? // validate drop downs too - FIXIT: don't know to generate the red stars here...
       // That's why we workaround by displaying a separate alert message ?>
    if ( document.forms.membercard.Mitgliedschaft.selectedIndex == 0 ) dderrs +=1;
    if ( document.forms.membercard.Zivilstand.selectedIndex == 0 ) dderrs +=1;
    if ( document.forms.membercard.Geschlecht.selectedIndex == 0 ) dderrs +=1;

    if (errs>1) alert('<? echo LANG_MULTI_INPUT_ERR ?>');
    if (errs==1) alert('<? echo LANG_SINGLE_INPUT_ERR ?>');

    if (dderrs>1) { alert('<? echo LANG_MULTI_DROPDOWN_ERR ?>'); errs=1; }
    if (dderrs==1) { alert('<? echo LANG_SINGLE_DROPDOWN_ERR ?>'); errs=1; }

    return (errs==0);
  };
</SCRIPT>

<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='5'>
    <TR>
        <TH class='titel_hinweis'>
            <?
            switch($action) {
            case "edit":
                    echo LANG_EDIT_EXISTING_RECORD;
                    break;
            case "new":
                    echo LANG_CREATE_NEW_RECORD;
                    break;
            default:
                    echo LANG_VIEW_DETAILS;
                    break;
            }
            ?>
        </TH>
    </TR>
    <TR>
       <TD VALIGN='top'>
          <? // Output of the member data table (left side) ?>
          <TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>

	<TR>
        <TD colspan='2'>
        	<TABLE WIDTH='100%' BORDER='0'>
	        <TR VALIGN='bottom'><TD>
<?
			switch($action) {
			case "new":
 			case "edit":
                    ?>
                    <FORM NAME='membercard' method='POST' onsubmit="return validateOnSubmit()" action='submit.php'>
                     <TABLE border='0'>
                      <TR><TD COLSPAN='2'><? echo LANG_LASTNAME ?></TD><TD COLSPAN='2'><? echo LANG_FORENAME ?></TD></TR>
                      <TR>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='Nachname'
                            ID='Nachname'
                            ONCHANGE="validatePresent(this, 'inf_Nachname');"
                            maxlength='49'
                            VALUE='<? if (!empty($Nachname)) echo $Nachname ?>'>
                        </INPUT>
                       </TD>
                        <TD ID="inf_Nachname">&nbsp;</TD>
                       <TD>
                        <INPUT
                            TYPE='text'
                            NAME='Vorname'
                            ID='Vorname'
                            ONCHANGE="validatePresent(this, 'inf_Vorname');"
                            maxlength='49'
                            VALUE='<? if (!empty($Vorname)) echo $Vorname ?>'>
                        </INPUT>
                       </TD>
                        <TD ID="inf_Vorname">&nbsp;</TD>
                      </TR>
                     </TABLE>
                    <?
			        break;
			default:
			        echo strtoupper($Nachname) . " $Vorname";
                    break;
			}
            ?>
		    </TD>
        </TR>
	    <TR VALIGN='top'><TD><HR></TD></TR>
    </TABLE>
    </TD></TR>

        <? // Let's output the membership number field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_NUMBER ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Mitgliednummer'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Mitgliednummer'
                                ID='Mitgliednummer'
                                ONCHANGE="validatePresent(this, 'inf_Mitgliednummer');"
                                MAXLENGTH='6'
                                VALUE='<? if (!empty($Mitgliednummer)) echo $Mitgliednummer ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Mitgliednummer";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Mitgliednummer">&nbsp;</TD>
        </TR>

        <? // Let's output the title field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBER_TITLE ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Titel'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Titel'
                                ID='Titel'
                                <? //ONCHANGE="validatePresent(this, 'inf_Titel');" ?>
                                MAXLENGTH='6'
                                VALUE='<? if (!empty($Titel)) echo $Titel ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Titel";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Titel">&nbsp;</TD>
        </TR>

        <? // Let's output the birth date field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_DATE_OF_BIRTH ?>:</TD>
		    <TD class='detail_view_conts'><?
			    switch($action) {
			case 'edit':
                require_once("include/datepicker.php"); ?>
				<INPUT
                    NAME='Geburtsdatum'
                    id='DPC_Geburtsdatum'
                    VALUE='<? echo make_nice_date("$Geburtsdatum") ?>'>
                </INPUT><?
				break;
			case 'new':
                require_once("include/datepicker.php"); ?>
				<INPUT
                    NAME='Geburtsdatum'
                    id='DPC_Geburtsdatum'>
                </INPUT><?
				break;
			default:
				echo make_nice_date("$Geburtsdatum");
			} ?>
            </TD>
        </TR>

        <? // Let's output the title field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_OCCUPATION ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Beruf'><?
                    switch($action) {
                    case "new":
                    case "edit": ?>
                        <INPUT
                            NAME='Beruf'
                            ID='Beruf'
                            <? //ONCHANGE="validatePresent(this, 'inf_Beruf');" ?>
                            MAXLENGTH='49'
                            VALUE='<? if (!empty($Beruf)) echo $Beruf ?>'>
                        </INPUT><?
                        break;
                    default:
                        echo "$Beruf";
                        break;
                    } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Beruf">&nbsp;</TD>
        </TR>

        <? // Let's output the membership start field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_START ?>:</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Eintritt'
                            id='DPC_Eintritt'
                            VALUE='<? echo make_nice_date("$Eintritt") ?>'>
                        </INPUT><?
				        break;
                    case 'new':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Eintritt'
                            id='DPC_Eintritt'
                            VALUE='<? echo make_nice_date("$date") ?>'>
                        </INPUT><?
				        break;
                    default:
                        echo make_nice_date("$Eintritt");
                        break;
                    } ?>
            </TD>
        </TR>

        <? // Let's output the membership end field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP_END ?>:</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        require_once('include/datepicker.php'); ?>
                        <INPUT
                            NAME='Austritt'
                            id='DPC_Austritt'
                            VALUE='<? echo make_nice_date("$Austritt") ?>'>
                        </INPUT> <?
                        break;
                    case 'new':
                        break;
                    default:
                        echo ( $Austritt != '0000-00-00' ) ? make_nice_date("$Austritt") : '';
                    } ?>
            </TD>
        </TR>

        <? // Let's output the membership type field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_MEMBERSHIP ?>:</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case 'edit':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) { ?>
                                    <OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    case 'new':
                        $result = get_dropdown('Mitgliedschaft'); ?>
                        <SELECT NAME='Mitgliedschaft_ID' ID='Mitgliedschaft'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                		        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    // Don't show alumni group on 'new'
                                    if ( $row['Mitgliedschaft'] == 'MEMBERSHIP_ALUMNI' ) { continue; }
                                    ?><OPTION<?
                                        if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Mitgliedschaft");
                        break;
			        } ?>
                </SELECT>
            </TD>
            <TD COLSPAN='2' ID="inf_Mitgliedschaft_ID">&nbsp;</TD>
        </TR>

        <? // Let's output the civil status field ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_CIVIL_STATUS ?>:</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
                    case "edit":
                    case "new":
                        $result = get_dropdown('Zivilstand'); ?>
                        <SELECT NAME='Zivilstand_ID' ID='Zivilstand'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Zivilstand_ID'] == "$Zivilstand_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Zivilstand_ID]'>" . constant("$row[Zivilstand]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Zivilstand");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's have sex ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SEX ?>:</TD>
            <TD class='detail_view_conts'><?
                    switch($action) {
			        case "edit":
			        case "new":
                        $result = get_dropdown('Geschlecht'); ?>
                        <SELECT NAME='Geschlecht_ID' ID='Geschlecht'>
                            <OPTION><? echo LANG_PLEASE_CHOOSE ?></OPTION> <?
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    ?><OPTION<?
                                        if ( $row['Geschlecht_ID'] == "$Geschlecht_ID" ) { echo ' SELECTED'; }
                                        echo " VALUE='$row[Geschlecht_ID]'>" . constant("$row[Geschlecht]");
                                    ?></OPTION><?
                                }
                        break;
                    default:
                        echo constant("$Geschlecht");
                        break;
                    } ?>
                    </SELECT>
            </TD>
        </TR>

        <? // Let's output the specific yes/no question ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_SPECIFIC_YESNO ?>:</TD>
            <TD class='detail_view_conts'><?
                switch($action) {
                case 'edit': ?>
			    	<SELECT NAME='GL'><?
			    	    foreach (range('0','1') as $line) {
                            ?><OPTION<?
				                if ( "$line" == "$GL" ) { echo ' SELECTED '; }
				                echo " VALUE='$line'>";
				                echo ("$line" == 1) ? LANG_YES : LANG_NO;
				            ?></OPTION><?
			     	    } ?>
                    </SELECT><?
                    break;
                case "new": ?>
                    <SELECT NAME='GL'><?
                        foreach (range('0','1') as $line) {
                            ?><OPTION<?
                                if ( "$line" == 1 ) { echo ' SELECTED '; }
                                echo " VALUE='$line'>";
                                echo ("$line" == 1) ? LANG_YES : LANG_NO;
                            ?></OPTION><?
                        } ?>
                    </SELECT><?
                    break;
                default:
                    echo ("$GL" == 1) ? LANG_YES : LANG_NO;
                    break;
                } ?>
            </TD>
        </TR>

    <? // Let's output the specific yes/no question ?><?
    switch($action) {
    case "edit":
    case "new":
        break;
    default: ?>
        <TR>
            <TD class='detail_view_entry'><? echo LANG_LAST_UPDATE ?>:</TD>
            <TD class='detail_view_conts'><? echo make_nice_date("$Update") .' / '. getUpdatedBy("$Mitglied_ID"); ?></TD>
        </TR><?
	  } ?>


	</TABLE>
	    <TABLE WIDTH='99%' BORDER='0'>
	        <TR><TD COLSPAN='2'><HR></TD></TR>
	    </TABLE>
    </TD>

    <? // Output of the address table ?>
    <TD VALIGN='top'>
    <TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>
        <TR><TD colspan='2'>
            <TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>
	            <TR ALIGN='right' VALIGN='bottom'>
<?		
		// Do not show header hyperlink if already selected.
		// uses a function to count number of address tables
		// People may just add another table 'Adresse..' to use it
		// If in 'edit' or 'new' mode the links disappear for usability
		// and protection
		$number_address_tables = get_table_number('Adresse');
		foreach (range('1', "$number_address_tables") as $num) {
			if ($Adress_ID != $num ) {
			     echo "<TD BGCOLOR='lightgrey'>";
			     switch($action) {
			     case "edit":
			     case "new":
				   echo "$num. " . LANG_ADRESS;
			 	   break;
			     default:
				   echo "<A HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$num'>$num. " . LANG_ADRESS . "</A>";
			     }
			     echo "</TD>\n";	
			} else {
			     echo "<TD BGCOLOR='gainsboro'><FONT COLOR='green'>$num. " . LANG_ADRESS . "</FONT></TD>\n";	
			}
		}
?>
	            </TR>
		        <TR VALIGN='top'><TD COLSPAN='<? $number_address_tables ?>'><HR></TD></TR>
            </TABLE>
	    </TD></TR>

        <? // Let's output the address field number one ?>
        <TR><TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?>1:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Adressfeld1'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Adressfeld1'
                                ID='Adressfeld1'
                                <? if ($Adress_ID == '1') { ?>
                                    ONCHANGE="validatePresent(this, 'inf_Adressfeld1');"
                                <? } ?>
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Adressfeld1)) echo $Adressfeld1 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Adressfeld1";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Adressfeld1">&nbsp;</TD>
        </TR>

        <? // Let's output the address field number two ?>
        <TR><TD class='detail_view_entry'><? echo LANG_ADRESSFIELD ?>2:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Adressfeld2'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Adressfeld2'
                                ID='Adressfeld2'
                                <? //ONCHANGE="validatePresent(this, 'inf_Adressfeld2');" ?>
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Adressfeld2)) echo $Adressfeld2 ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Adressfeld2";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Adressfeld2">&nbsp;</TD>
        </TR>

        <? // Let's output the state field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_STATE ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Kanton'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Kanton'
                                ID='Kanton'
                                <? //ONCHANGE="validatePresent(this, 'inf_Kanton');" ?>
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Kanton)) echo $Kanton ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Kanton";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Kanton">&nbsp;</TD>
        </TR>

        <? // Let's output the postal code field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_POSTAL_CODE ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Postleitzahl'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Postleitzahl'
                                ID='Postleitzahl'
                                <? if ($Adress_ID == '1') { ?>
                                    ONCHANGE="validatePresent(this, 'inf_Postleitzahl');"
                                <? } ?>
                                MAXLENGTH='6'
                                VALUE='<? if (!empty($Postleitzahl)) echo $Postleitzahl ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Postleitzahl";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Postleitzahl">&nbsp;</TD>
        </TR>

        <? // Let's output the city field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_CITY ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Stadt'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Stadt'
                                ID='Stadt'
                                <? if ($Adress_ID == '1') { ?>
                                    ONCHANGE="validatePresent(this, 'inf_Stadt');"
                                <? } ?>
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Stadt)) echo $Stadt ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Stadt";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Stadt">&nbsp;</TD>
        </TR>

        <? // Let's output the country field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_COUNTRY ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Land'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Land'
                                ID='Land'
                                <? if ($Adress_ID == '1') { ?>
                                    ONCHANGE="validatePresent(this, 'inf_Land');"
                                <? } ?>
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Land)) echo $Land ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Land";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Land">&nbsp;</TD>
        </TR>

        <? // Let's output the phone number field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_PHONE ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Telephon'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Telephon'
                                ID='Telephon'
                                ONCHANGE="validateTelnr(this, 'inf_Telephon', false);"
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Telephon)) echo $Telephon ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Telephon";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Telephon">&nbsp;</TD>
        </TR>

        <? // Let's output the fax number field ?>
        <TR><TD class='detail_view_entry'><? echo LANG_FAX ?>:</TD>
            <TD class='detail_view_conts'>
                <LABEL FOR='Telefax'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='Telefax'
                                ID='Telefax'
                                ONCHANGE="validateTelnr(this, 'inf_Telefax', false);"
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Telefax)) echo $Telefax ?>'>
                            </INPUT> <?
                            break;
                        default:
                            echo "$Telefax";
                            break;
                        } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Telefax">&nbsp;</TD>
        </TR>

        <? // Let's output the mobile number field ?> 
	    <TR><TD class='detail_view_entry'><? echo LANG_CELLPHONE ?>:</TD>
		    <TD class='detail_view_conts'>
                <LABEL FOR='Mobil'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                        	<INPUT
                                NAME='Mobil'
                                ID='Mobil'
                                ONCHANGE="validateTelnr(this, 'inf_Mobil', false);"
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($Mobil)) echo $Mobil ?>'>
                            </INPUT> <?
		    		        break;
			            default:
                            echo "$Mobil";
                            break;
			            } ?>
                </LABEL>
            </TD>
            <TD COLSPAN='2' ID="inf_Mobil">&nbsp;</TD>
        </TR>

        <? // Let's output the email field ?>
	    <TR><TD CLASS='detail_view_entry'><? echo LANG_EMAIL ?>:</TD>
		    <TD CLASS='detail_view_conts'>
                <LABEL FOR='EMail'>
                     <? switch($action) {
                        case "new":
                        case "edit": ?>
                            <INPUT
                                NAME='EMail' 
                                ID='EMail'
                                ONCHANGE="validateEmail(this, 'inf_EMail', false);"
                                MAXLENGTH='49'
                                VALUE='<? if (!empty($EMail)) echo $EMail ?>'>
                            </INPUT> <?
				            break;
                        default: ?>
                            <A CLASS='nolink' HREF='mailto:<? echo $EMail ?>'><? echo $EMail ?></A> <?
                            break;
			            } ?>
                </LABEL>
            </TD>
          <TD COLSPAN='2' ID="inf_EMail">&nbsp;</TD>
        </TR>

      </TABLE>

      <TABLE WIDTH='99%' BORDER='0'>
        <TR><TD COLSPAN='2'><HR></TD></TR>
        <TR><TD COLSPAN='2' align='right'>
<?    
    switch($action) {
    case "edit":
        if (isEnabled($userlist,$grouplist)) {
                echo "\t\t<INPUT TYPE='hidden' name='action' value='edit'>\n";
                echo "\t\t<INPUT TYPE='hidden' name='Mitglied_ID' value='$Mitglied_ID'>\n";
                echo "\t\t<INPUT TYPE='hidden' name='Adress_ID' value='$Adress_ID'>\n";
                echo "\t\t<INPUT TYPE='button' value='" . LANG_BACK . "' onclick=history.go(-1)>\n";
                echo "\t\t<INPUT TYPE='submit' value='" . LANG_NEXT . "'>\n";
        }
        echo "\t</TD></TR></FORM>";
		break;
	  case "new":
        if (isEnabled($userlist,$grouplist)) {
		    echo "\t\t<INPUT TYPE='hidden' name='action' value='new'>\n";
		    echo "\t\t<INPUT TYPE='hidden' name='Mitglied_ID' value='$Mitglied_ID'>\n";
		    echo "\t\t<INPUT TYPE='hidden' name='Adress_ID' value='$Adress_ID'>\n";
		    echo "\t\t<INPUT TYPE='button' value='" . LANG_BACK . "' onclick=history.go(-1)>\n";
		    echo "\t\t<INPUT TYPE='submit' value='" . LANG_NEXT . "'>\n";
        }
		echo "\t</TD></TR></FORM>";
		break;
	  default:	
	        echo "| <A class='normal' HREF='print.php?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=detail'>" . LANG_GENERATE_LABEL_PDF . "</A> ";
            if (isEnabled($userlist,$grouplist)) {
	            echo "| <A class='normal' HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=edit'>" . LANG_UPDATE . "</A> ";
            }
		echo "|</TD></TR>\n";
	  }
        echo "</TABLE>\n";


     echo "</TD>\n";
    echo "</TR>\n";
   echo "</TABLE>\n";

?>

  </TD>
 </TR>
</TABLE>

<?
include("include/footer.inc");
?>
