<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

require("include/header.inc");
require("include/dbconnect.php");

// Only people of the phpAuthent group 'edit' may submit the form
require_once(PHPMYMEMBERS_DIR . "/include/phpauthent/phpauthent_core.php");
$userlist = array("");
$grouplist = array("edit");


// We show a Javascript box when insert/update was
// successfully done on db within 'submit.php'.
if ( CONFIRM_DB_WRITES_WITH_POPUP == 'true' ) {
	if ($_REQUEST['status'] == 'ok') {
		echo "<script>alert(\"" . LANG_DATABASE_SUCCESS . "\")</script>";
	}
}

?>

<TABLE class='main'>
 <TR>
   <TD>

<?

// Find out which address we should display
$Adress_ID     	= (isset($_REQUEST['address']))  ?  $_REQUEST['address']  :  "1";
$address_table 	= "Adresse" . "$Adress_ID";
$action	       	= $_REQUEST['action'];
$date		= date("Y-m-d");

// Only query database if Mitglied_ID is selected, otherwise we are in 'new'
// mode and thus can't query anything yet which would produce mysql errors
if ( !empty($_REQUEST['Mitglied_ID']) ) {

	// Make life easier
	$Mitglied_ID = $_REQUEST['Mitglied_ID'];

	// Query main db table and set php variables
	$main_query     = sprintf("
			SELECT * FROM `Mitglied` m, `Geschlecht` g, `Zivilstand` z, `Mitgliedschaft` s
			WHERE m.Mitglied_ID=%s
			and   m.Geschlecht_ID=g.Geschlecht_ID
			and   m.Mitgliedschaft_ID=s.Mitgliedschaft_ID
			and   m.Zivilstand_ID=z.Zivilstand_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($main_query,$db);
		$row    = mysql_fetch_array($result);

		$Mitgliednummer     = $row['Mitgliednummer'];
		$Nachname 	        = $row['Nachname'];
		$Vorname 	        = $row['Vorname'];
		$Geburtsdatum 	    = $row['Geburtsdatum'];
		$Eintritt 	        = $row['Eintritt'];
		$Austritt 	        = $row['Austritt'];
		$Mitgliedschaft_ID  = $row['Mitgliedschaft_ID'];
		$Mitgliedschaft     = $row['Mitgliedschaft'];
		$Zivilstand_ID	    = $row['Zivilstand_ID'];
		$Zivilstand	        = $row['Zivilstand'];
		$Geschlecht_ID	    = $row['Geschlecht_ID'];
		$Geschlecht	        = $row['Geschlecht'];
		$Update 	        = $row['Update'];
		$Beruf 		        = $row['Beruf'];
		$Titel 		        = $row['Titel'];
		$GL 		        = $row['GL'];

	// Query address db tables and set php variables
	// Not fetching anything again should be quicker
	$address_query	= sprintf("
			SELECT m.Mitglied_ID, a.Adressfeld1, a.Adressfeld2, a.Kanton, a.Postleitzahl,
			       a.Stadt, a.Land, a.Telephon, a.Telefax, a.Mobil, a.EMail, a.Mitglied_ID
		        FROM `Mitglied` m, `$address_table` a
			WHERE m.Mitglied_ID=%s
			and   m.Mitglied_ID=a.Mitglied_ID",
			quote_smart($Mitglied_ID));

		$result = mysql_query($address_query,$db);
		$row    = mysql_fetch_array($result);

		$Adressfeld1    = $row['Adressfeld1'];
		$Adressfeld2    = $row['Adressfeld2'];
		$Kanton    	    = $row['Kanton'];
		$Postleitzahl   = $row['Postleitzahl'];
		$Stadt   	    = $row['Stadt'];
		$Land		    = $row['Land'];
		$Telephon    	= $row['Telephon'];
		$Telefax	    = $row['Telefax'];
		$Mobil		    = $row['Mobil'];
		$EMail		    = $row['EMail'];
}

   echo "<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='5'>\n";

    echo "<TR><TH class='titel_hinweis'>";
    switch($action) {
    case "edit": 	echo LANG_EDIT_EXISTING_RECORD;
			break;
    case "new": 	echo LANG_CREATE_NEW_RECORD;
			break;
    default: 		echo LANG_VIEW_DETAILS;
    }
    echo "</TH></TR>\n";

    echo "<TR>\n";
     echo "<TD VALIGN='top'>\n";

	// Output of the member data table (left side)
	echo "<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>\n";
	switch($action) {
	case "new":
	  echo "\t<TR><TD>" . LANG_LASTNAME . "</TD>
                      <TD>" . LANG_FORENAME . "</TD></TR>\n";
	  break;
	}
	  echo "\t<TR><TD colspan='2'>\n";
	  
        	echo "\t\t<TABLE WIDTH='100%' BORDER='0'>\n";
	        echo "\t\t\t<TR VALIGN='bottom'><TR>\n";
			switch($action) {
 			case "edit":
                              echo "\t\t\t\t<FORM method='POST' action='submit.php'>\n";
                              echo "\t\t\t\t<INPUT TYPE='text' NAME='Nachname' maxlength='49' VALUE='" . $Nachname . "'></INPUT>\n";
                              echo "\t\t\t\t<INPUT TYPE='text' NAME='Vorname' maxlength='49' VALUE='" . $Vorname . "'></INPUT>\n";
			      break;
			case "new":
                              echo "\t\t\t\t<FORM method='POST' action='submit.php'>\n";
                              echo "\t\t\t\t<INPUT TYPE='text' NAME='Nachname' maxlength='49' VALUE=''></INPUT>\n";
                              echo "\t\t\t\t<INPUT TYPE='text' NAME='Vorname' maxlength='49' VALUE=''></INPUT>\n";
			      break;
			default:
			      echo strtoupper($Nachname) . " $Vorname";
			}
		echo "\t\t\t</TR></TR>\n";
		echo "\t\t\t<TR VALIGN='top'><TD><HR></TD></TR>\n";
        	echo "\t\t</TABLE>\n";
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_MEMBERSHIP_NUMBER . ":</TD>
		      <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
				echo "<INPUT NAME='Mitgliednummer' maxlength='6' VALUE='" . $Mitgliednummer . "'></INPUT>";
				break;
			case "new":
				echo "<INPUT NAME='Mitgliednummer' maxlength='6'></INPUT>";
				break;
			default:
				echo "$Mitgliednummer";
			}
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_MEMBER_TITLE . ":</TD>
		      <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
				echo "<INPUT NAME='Titel' maxlength='9' VALUE='" . $Titel . "'></INPUT>";
				break;
			case "new":
				echo "<INPUT NAME='Titel' maxlength='9'></INPUT>";
				break;
			default:
				echo "$Titel";
			}
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_DATE_OF_BIRTH . ":</TD>
		      <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                require_once("include/datepicker.php");
				echo "<INPUT NAME='Geburtsdatum' id='DPC_Geburtsdatum' VALUE='" . make_nice_date("$Geburtsdatum") . "'></INPUT>";
				break;
			case "new":
                require_once("include/datepicker.php");
				echo "<INPUT NAME='Geburtsdatum' id='DPC_Geburtsdatum'></INPUT>";
				break;
			default:
				echo make_nice_date("$Geburtsdatum");
			}
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_OCCUPATION . ":</TD>
		      <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
				echo "<INPUT NAME='Beruf' maxlength='49' VALUE='" . $Beruf . "'></INPUT>";
				break;
			case "new":
				echo "<INPUT NAME='Beruf' maxlength='49'></INPUT>";
				break;
			default:
				echo "$Beruf";
			}
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_MEMBERSHIP_START . ":</TD>
		      <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                require_once("include/datepicker.php");
				echo "<INPUT NAME='Eintritt' id='DPC_Eintritt' VALUE='" . make_nice_date("$Eintritt") . "'></INPUT>";
				break;
			case "new":
                require_once("include/datepicker.php");
				echo "<INPUT NAME='Eintritt' id='DPC_Eintritt' VALUE='" . make_nice_date("$date") . "'></INPUT>";
				break;
			default:
				echo make_nice_date("$Eintritt");
			}
	  echo "\t</TD></TR>\n";

      echo "\t<TR><TD class='detail_view_entry'>" . LANG_MEMBERSHIP_END . ":</TD>
              <TD class='detail_view_conts'>";
            switch($action) {
            case "edit":
                require_once("include/datepicker.php");
                echo "<INPUT NAME='Austritt' id='DPC_Austritt' VALUE='" . make_nice_date("$Austritt") . "'></INPUT>";
                break;
            case "new":
                 break;
            default:
                 echo ( $Austritt != '0000-00-00' ) ? make_nice_date("$Austritt") : '';
            }
      echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_MEMBERSHIP . ":</TD>
		      <TD class='detail_view_conts'>\n";
			switch($action) {
			case "edit":
                                $result = get_dropdown('Mitgliedschaft');
                                echo "\t\t\t<SELECT NAME='Mitgliedschaft_ID'>\n";
                                echo "\t\t\t\t<OPTION>" . LANG_PLEASE_CHOOSE . "</OPTION>\n";
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    echo "\t\t\t\t<OPTION";
                                    if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo " SELECTED"; }
                                    echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]") . "</OPTION>\n";
                                }
				break;
			case "new":
				$result = get_dropdown('Mitgliedschaft');
			        echo "\t\t\t<SELECT NAME='Mitgliedschaft_ID'>\n";
		                echo "\t\t\t\t<OPTION>" . LANG_PLEASE_CHOOSE . "</OPTION>\n";
                		while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
				    // Don't show alumni group on 'new'
				    if ( $row['Mitgliedschaft'] == 'MEMBERSHIP_ALUMNI' ) { continue; }
		                    echo "\t\t\t\t<OPTION";
                		    if ( $row['Mitgliedschaft_ID'] == "$Mitgliedschaft_ID" ) { echo " SELECTED"; }
		                    echo " VALUE='$row[Mitgliedschaft_ID]'>" . constant("$row[Mitgliedschaft]") . "</OPTION>\n";
		                }
                                break;
			default:
				echo constant("$Mitgliedschaft");
			}
			echo "\t\t\t</SELECT>\n";
	  echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_CIVIL_STATUS . ":</TD>
                      <TD class='detail_view_conts'>\n";
			switch($action) {
			case "edit":
			case "new":
                                $result = get_dropdown('Zivilstand');
                                echo "\t\t\t<SELECT NAME='Zivilstand_ID'>\n";
                                echo "\t\t\t\t<OPTION>" . LANG_PLEASE_CHOOSE . "</OPTION>\n";
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    echo "\t\t\t\t<OPTION";
                                    if ( $row['Zivilstand_ID'] == "$Zivilstand_ID" ) { echo " SELECTED"; }
                                    echo " VALUE='$row[Zivilstand_ID]'>" . constant("$row[Zivilstand]") . "</OPTION>\n";
                                }
				break;
			default:
                            echo constant("$Zivilstand");
                        }
			echo "\t\t\t</SELECT>\n";
          echo "\t</TD></TR>\n";

	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_SEX . ":</TD>
                      <TD class='detail_view_conts'>\n";
			switch($action) {
			case "edit":
			case "new":
                                $result = get_dropdown('Geschlecht');
                                echo "\t\t\t<SELECT NAME='Geschlecht_ID'>\n";
                                echo "\t\t\t\t<OPTION>" . LANG_PLEASE_CHOOSE . "</OPTION>\n";
                                while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) {
                                    echo "\t\t\t\t<OPTION";
                                    if ( $row['Geschlecht_ID'] == "$Geschlecht_ID" ) { echo " SELECTED"; }
                                    echo " VALUE='$row[Geschlecht_ID]'>" . constant("$row[Geschlecht]") . "</OPTION>\n";
                                }
				break;
			default:
                            echo constant("$Geschlecht");
                        }
			echo "\t\t\t</SELECT>\n";
          echo "\t</TD></TR>\n";

	  // 'Geisteslehre-Studium' is FIGU specific, needs to be generalised
	  echo "\t<TR><TD class='detail_view_entry'>" . LANG_SPECIFIC_YESNO . ":</TD>
		      <TD class='detail_view_conts'>\n";
			switch($action) {
			case "edit":
			    	echo "\t\t\t<SELECT NAME='GL'>\n";
			    	foreach (range('0','1') as $line) {
			            echo "\t\t\t\t<OPTION ";
				    if ( "$line" == "$GL" ) { echo "SELECTED "; }
				    echo "VALUE='$line'>";
				    echo ("$line" == 1) ? LANG_YES : LANG_NO;
				    echo "</OPTION>\n";
			     	}
				echo "\t\t\t</SELECT>\n";
				break;
			case "new":
                                echo "\t\t\t<SELECT NAME='GL'>\n";
                                foreach (range('0','1') as $line) {
                                    echo "\t\t\t\t<OPTION ";
                                    if ( "$line" == 1 ) { echo "SELECTED "; }
                                    echo "VALUE='$line'>";
                                    echo ("$line" == 1) ? LANG_YES : LANG_NO;
                                    echo "</OPTION>\n";
                                }
                                echo "\t\t\t</SELECT>\n";
                                break;
			default:
			    echo ("$GL" == 1) ? LANG_YES : LANG_NO;
			}
	  echo "\t</TD></TR>\n";
	
	  switch($action) {
	  case "edit":
	  case "new":
	       break;
	  default:
	       echo "\t<TR><TD class='detail_view_entry'>" . LANG_LAST_UPDATE . ":</TD>
                           <TD class='detail_view_conts'>" . make_nice_date("$Update") . "</TD></TR>\n";
	  }

	echo "</TABLE>\n";


	echo "<TABLE WIDTH='99%' BORDER='0'>\n";
	  echo "\t<TR><TD COLSPAN='2'><HR></TD></TR>\n";
	echo "</TABLE>\n";
     echo "</TD>\n";


     // Output of the address table
     echo "<TD VALIGN='top'>\n";
      echo "<TABLE BORDER='0' bgcolor='gainsboro' CELLPADDING='3' CELLSPACING='5'>\n";
	echo "\t<TR><TD colspan='2'>";
        	echo "<TABLE WIDTH='100%' HEIGHT='50' BORDER='0'>\n";
	        echo "\t<TR ALIGN='right' VALIGN='bottom'>";
		
		// Do not show header hyperlink if already selected.
		// uses a function to count number of address tables
		// People may just add another table 'Adresse..' to use it
		// If in 'edit' or 'new' mode the links disappear for usability
		// and protection
		$number_address_tables = get_table_number('Adresse');
		foreach (range('1', "$number_address_tables") as $num) {
			if ($Adress_ID != $num ) {
			     echo "<TD BGCOLOR='lightgrey'>";
			     switch($action) {
			     case "edit":
			     case "new":
				   echo "$num. " . LANG_ADRESS;
			 	   break;
			     default:
				   echo "<A HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$num'>$num. " . LANG_ADRESS . "</A>";
			     }
			     echo "</TD>\n";	
			} else {
			     echo "<TD BGCOLOR='gainsboro'><FONT COLOR='green'>$num. " . LANG_ADRESS . "</FONT></TD>\n";	
			}
		}

	        echo "\t</TR>\n";
		echo "\t<TR VALIGN='top'><TD COLSPAN='$number_address_tables'><HR></TD></TR>\n";
        	echo "</TABLE>\n";

	echo "\t</TD></TR>";
	echo "\t<TR><TD class='detail_view_entry'>" . LANG_ADRESSFIELD . "1:</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
				echo "<INPUT NAME='Adressfeld1' maxlength='49' VALUE='" . $Adressfeld1 . "'></INPUT>";
				break;
			case "new":
				echo "<INPUT NAME='Adressfeld1' maxlength='49'></INPUT>";
				break;
			default:
				echo "$Adressfeld1";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_ADRESSFIELD . "2:</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                        	echo "<INPUT NAME='Adressfeld2' VALUE='" . $Adressfeld2 . "'></INPUT>";
				break;
			case "new":
                        	echo "<INPUT NAME='Adressfeld2'></INPUT>";
				break;
			default:
                               	echo "$Adressfeld2";
			}
	echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_STATE . ":</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
				echo "<INPUT NAME='Kanton' maxlength='49' VALUE='" . $Kanton . "'></INPUT>";
				break;
			case "new":
				echo "<INPUT NAME='Kanton' maxlength='49'></INPUT>";
				break;
			default:
				echo "$Kanton";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_POSTAL_CODE . ":</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                        	echo "<INPUT NAME='Postleitzahl' maxlength='6' VALUE='" . $Postleitzahl . "'></INPUT>";
				break;
			case "new":
                        	echo "<INPUT NAME='Postleitzahl' maxlength='6'></INPUT>";
				break;
			default:
                               	echo "$Postleitzahl";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_CITY . ":</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                        	echo "<INPUT NAME='Stadt' maxlength='49' VALUE='" . $Stadt . "'></INPUT>";
				break;
			case "new":
                        	echo "<INPUT NAME='Stadt' maxlength='49'></INPUT>";
				break;
			default:
                                echo "$Stadt";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_COUNTRY . ":</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
			case "edit":
                        	echo "<INPUT NAME='Land' maxlength='49' VALUE='" . $Land . "'></INPUT>";
				break;
			case "new":
                        	echo "<INPUT NAME='Land' maxlength='49'></INPUT>";
				break;
			default:
                                echo "$Land";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_PHONE . ":</TD>
		    <TD class='detail_view_conts'>";
			switch($action) {
                        case "edit":
                        	echo "<INPUT NAME='Telephon' maxlength='49' VALUE='" . $Telephon . "'></INPUT>";
				break;
                        case "new":
                        	echo "<INPUT NAME='Telephon' maxlength='49'></INPUT>";
				break;
			default:
                                echo "$Telephon";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_FAX . ":</TD>
		    <TD class='detail_view_conts'>";
                        switch($action) {
                        case "edit":
                        	echo "<INPUT NAME='Telefax' maxlength='49' VALUE='" . $Telefax . "'></INPUT>";
				break;
                        case "new":
                        	echo "<INPUT NAME='Telefax' maxlength='49'></INPUT>";
				break;
			default:
                                echo "$Telefax";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_CELLPHONE . ":</TD>
		    <TD class='detail_view_conts'>";
                        switch($action) {
                        case "edit":
                        	echo "<INPUT NAME='Mobil' maxlength='49' VALUE='" . $Mobil . "'></INPUT>";
				break;
                        case "new":
                        	echo "<INPUT NAME='Mobil' maxlength='49'></INPUT>";
				break;
			default:
                                echo "$Mobil";
			}
        echo "\t</TD></TR>\n";

	echo "\t<TR><TD class='detail_view_entry'>" . LANG_EMAIL . ":</TD>
		    <TD class='detail_view_conts'>";
                        switch($action) {
                        case "edit":
                        	echo "<INPUT NAME='EMail' maxlength='49' VALUE='" . $EMail . "'></INPUT>";
				break;
                        case "new":
                        	echo "<INPUT NAME='EMail' maxlength='49'></INPUT>";
				break;
			default:
                                echo "<A class='nolink' HREF='mailto:" . "$EMail" . "'>$EMail</A>";
			}
      echo "\t</TD></TR>\n";

      echo "</TABLE>\n";

        echo "<TABLE WIDTH='99%' BORDER='0'>\n";
          echo "\t<TR><TD COLSPAN='2'><HR></TD></TR>\n";
          echo "\t<TR><TD COLSPAN='2' align='right'>\n";
	  switch($action) {
	  case "edit":
        if (isEnabled($userlist,$grouplist)) {
                echo "\t\t<INPUT TYPE='hidden' name='action' value='edit'>\n";
                echo "\t\t<INPUT TYPE='hidden' name='Mitglied_ID' value='$Mitglied_ID'>\n";
                echo "\t\t<INPUT TYPE='hidden' name='Adress_ID' value='$Adress_ID'>\n";
                echo "\t\t<INPUT TYPE='button' value='" . LANG_BACK . "' onclick=history.go(-1)>\n";
                echo "\t\t<INPUT TYPE='submit' value='" . LANG_NEXT . "'>\n";
        }
        echo "\t</TD></TR></FORM>";
		break;
	  case "new":
        if (isEnabled($userlist,$grouplist)) {
		    echo "\t\t<INPUT TYPE='hidden' name='action' value='new'>\n";
		    echo "\t\t<INPUT TYPE='hidden' name='Mitglied_ID' value='$Mitglied_ID'>\n";
		    echo "\t\t<INPUT TYPE='hidden' name='Adress_ID' value='$Adress_ID'>\n";
		    echo "\t\t<INPUT TYPE='button' value='" . LANG_BACK . "' onclick=history.go(-1)>\n";
		    echo "\t\t<INPUT TYPE='submit' value='" . LANG_NEXT . "'>\n";
        }
		echo "\t</TD></TR></FORM>";
		break;
	  default:	
	        echo "| <A class='normal' HREF='print.php?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=detail'>" . LANG_GENERATE_LABEL_PDF . "</A> ";
            if (isEnabled($userlist,$grouplist)) {
	            echo "| <A class='normal' HREF='$_SERVER[PHP_SELF]?Mitglied_ID=$Mitglied_ID&address=$Adress_ID&action=edit'>" . LANG_UPDATE . "</A> ";
            }
		echo "|</TD></TR>\n";
	  }
        echo "</TABLE>\n";


     echo "</TD>\n";
    echo "</TR>\n";
   echo "</TABLE>\n";

?>

  </TD>
 </TR>
</TABLE>

<?
include("include/footer.inc");
?>
