<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    statistiques.php
Version : 	1.0
Date : 	    15th May 2004
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Show statistques for all questions for the moment
*******************************************************************************/
	require_once("parameters.inc.php");
	require_once(PHPMCQ_HOME . 'PageLayout.class.php');
	require_once(PHPMCQ_HOME . 'DataBase.class.php');
	require_once(PHPMCQ_HOME . 'Table.class.php');
	require_once(PHPMCQ_HOME . 'utils.php');

require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);

  function getNumberOfSuccess($myDB, $id_questionnaire, $id_question)
  {
  	$nbRight=0;
    $i=0;
    $right[$i]=0;
  	$request = 	"select id_suggestion from answers" .
		" where id_question=$id_question";
    
    $suggestions=$myDB->execRequete($request);
   	
    while($suggestion=$myDB->objetSuivant($suggestions))
    {
    	$right[$i]=$suggestion->id_suggestion;
    	$i++;
    }
    
    $request = 	"select id_result from results" .
		" where id_question=$id_question" .
    " and id_questionnaire=$id_questionnaire";
    
    $results=$myDB->execRequete($request);
    while($result=$myDB->objetSuivant($results))
    {
    	$juste=true;
    	$request= "select * from history where id_result=$result->id_result";
      $propositions=$myDB->execRequete($request);
      while($proposition=$myDB->objetSuivant($propositions))
      {
      	if(!IsRight($proposition->id_suggestion,$right))
        {
        	$juste=false;
          break;
        }
      }
      if($juste)
      	$nbRight++;
    }
    return $nbRight;
  }
  
  include(INCLUDE_FILES_PATH . 'accessCheck.inc.php');
  
	$page=new PageLayout('WebQCM');
	$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
  $page->setTitleBar('<h1>Statistiques</h1>');
  
  $content=null;
  
	$subject=getVariable('subject',0);
  $questionnaire=getVariable('questionnaire', 0);
  
	$myDB = new dataBase();
  
  $content = $content . startForm($_SERVER['PHP_SELF']);
    
  // get subjects
	$request = "SELECT * FROM subjects";
	$subjects=$myDB->execRequete($request);
	$subjectTxt="<select name=\"subject\" onchange=\"submit()\">\n";
	$subjectTxt=$subjectTxt."<option value=\"0\" selected=\"selected\">choisir un sujet...</option>\n";
	while($sub=$myDB->objetSuivant($subjects))
	{
  	if($sub->id_subject != 1) // 'aucun' item
    {
    	if($sub->id_subject==$subject)
    	{
     		$subjectTxt=$subjectTxt."<option value=\"".$sub->id_subject."\" selected=\"selected\">".$sub->subject."</option>\n";
    	}
    	else
    	{
     		$subjectTxt=$subjectTxt."<option value=\"".$sub->id_subject."\">".$sub->subject."</option>\n";
    	}
    }
  }
	$subjectTxt=$subjectTxt."</select>\n";
  
  $content = $content . "Slctionner un sujet : " . $subjectTxt;
 	
  if($subject != 0)
  {
  	// - On peut proposer de slctionner un questionnaire
    // - Afficher les statistiques concernant ce sujet
    
    // get all questionnaire
		$request = "SELECT * FROM questionnaires where id_subject=$subject";
		$questionnaires=$myDB->execRequete($request);
		$questionnaireTxt="<select name=\"questionnaire\" onchange=\"submit()\">\n";
		$questionnaireTxt=$questionnaireTxt."<option value=\"0\" selected=\"selected\">choisir un questionnaire...</option>\n";
		while($quest=$myDB->objetSuivant($questionnaires))
		{
    	if($quest->id_questionnaire==$questionnaire)
    	{
     		$questionnaireTxt=$questionnaireTxt."<option value=\"".$quest->id_questionnaire."\" selected=\"selected\">".$quest->title."</option>\n";
    	}
    	else
    	{
     		$questionnaireTxt=$questionnaireTxt."<option value=\"".$quest->id_questionnaire."\">".$quest->title."</option>\n";
    	}
  	}
		$questionnaireTxt=$questionnaireTxt."</select>\n";
  
    $content = $content . "choisisser un questionnaire : " . $questionnaireTxt;
  
  	// Faire une table contenant les statistiques sur le sujet
  	// - nombre de tentatives
    
    //$statTable = new Table();
    
  	if($questionnaire == 0) // pas de questionnaire
    {
    
    	///////////
 			//$statTable->line();
			//$statTable->cell('questionnaire');
			//$statTable->cell('nombre de tentatives');
    
    	//$request = "SELECT * FROM questionnaires where id_subject=$subject";
			//$questionnaires=$myDB->execRequete($request);
    	//while($quest=$myDB->objetSuivant($questionnaires))
			//{
    	//	$statTable->line();
			//	$statTable->cell($quest->title);
			//	$statTable->cell(getNBTentative($myDB, $quest->id_questionnaire));
      //}
      
     $content=$content . image ("subjectStats.php?subject=$subject");
    }
    else // un questionnaire est choisi
    {
    	// on donne des stats sur le questionnaire
    	//$statTable->line();
			//$statTable->cell('Question');
			//$statTable->cell('Tentatives');
      //$statTable->cell('Russites');
      //$statTable->cell('Pourcentage de russite');
    
    	$request = "SELECT * FROM questionnaires_content, questions".
      	" where id_questionnaire=$questionnaire".
      	" and questionnaires_content.id_question=questions.id_question";
      
			$questions=$myDB->execRequete($request);
    	while($question=$myDB->objetSuivant($questions))
			{
      	
        $nbTry=getNBTentative($myDB, $questionnaire);
        //-- obtenir le nombre de rponses juste
				$nbSuccess=getNumberOfSuccess($myDB, $questionnaire, $question->id_question);
        $percentage=($nbSuccess!=0) ? ((($nbSuccess/$nbTry)*100).'%'):('0%');
    		if(!$question->open)
        {
        	$content=$content . image ("questionStats.php?questionnaire=$questionnaire&amp;question=$question->id_question");
      		$content=$content . "<p>".$nbTry." tentatives, ".$nbSuccess." succs, soit ".$percentage." de succs </p>";
        }
        else
        	$content=$content . "<br /> <br /> <br />  <p>question ouverte </p>";
        
      }
    }
    
    
  }
  
	$myDB->quitter();
  $content = $content . endForm();
  $page->setContent($content);
	echo $page->getPage($_SESSION['access']);
	
?>
