<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/   

define ('FATAL', 0);
define ('ERROR', 1);
define ('WARNING', 2);
define ('INFO', 3);
define ('DEBUG', 4);

define ('ERROR_FILE', 'errors.csv');

function log_error ($error_msg, $error_level) {
	$time = date( "d M Y H:i:s" );
	// Get the error type from the error number
	
	$error_level_string='';
	
	switch ($error_level){
	case FATAL: 	$error_level_string='FATAL'; 		break;
	case ERROR: 	$error_level_string='ERROR'; 		break;
	case WARNING: 	$error_level_string='WARNING';	break;
	case INFO: 		$error_level_string='INFO'; 		break;
	case DEBUG: 	$error_level_string='DEBUG'; 		break;
	default: 		$error_level_string='UNKNOWN';
	}
 
	//Write error to log file (CSV format)
	$errfile = fopen(ERROR_FILE, 'a' );
	fputs( $errfile,"[$time] --$error_level_string-- $error_msg\r\n" );
	fclose( $errfile );
 
	if ($error_level < 2) {
		// Terminate script if fatal errror
		die( "A fatal error has occured. Script execution has been aborted." );
	}
}
?>
