<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    design.php
Version : 	1.0
Date : 	    15th May 2004
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Define the design of the phpMCQ project
*******************************************************************************/
 
require_once('parameters.inc.php');
require_once(PHPMCQ_HOME . 'xhtml.php');

function pageHeader($pageTitle,$title,$menu=false)
{
    ///////////////////// do NOT touch this part /////////////////////
   // header('Content-Type: text/xml');
    $config="";
    $config=$config . "<?xml version=\"1.0\"?>\n";
    $config=$config . "<?xml-stylesheet type=\"text/xsl\"\n"; 
    $config=$config . "href=\"pmathml.xsl\"?>\n";
    $config=$config . "<html xmlns=\"http://www.w3.org/1999/xhtml\"\n";
    $config=$config . "xmlns:mml=\"http://www.w3.org/1998/Math/MathML\">\n";    
    $config=$config . "<head>\n";
    $config=$config . "<title>".$pageTitle."</title>\n";
    $config=$config . "<script type=\"text/javascript\"\n src=\"".JS_FILES_PATH."ASCIIMathML.js\"></script>\n";
    $config=$config . "<script type=\"text/javascript\"\n src=\"".JS_FILES_PATH."utils.js\"></script>\n";
	$config=$config . "<link rel=\"stylesheet\" href=\"".CSS_FILES_PATH."phpMCQ.css\" type=\"text/css\"/>\n";
    $config=$config . "</head>\n";
    $config=$config . "<body onload=\"translate(); resize();\">\n";
    //////////////////////////////////////////////////////////////////12
    
    /////////////// The code of header design is below ///////////////
	$headerBar="";
    $headerBar=$headerBar . "<div class=\"header\">\n";
    $headerBar=$headerBar . "<h1>" . $title . "</h1>\n";
	//$headerBar=$headerBar . "</div>\n";
    
    //////////// The code of the menu bar design is below ////////////15
 	 $menuBar="";
    if($menu)
    {
	$menuBar=$menuBar . "<div class=\"top-menu\">\n";
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."statistiques.php\">statistiques</a>\n";
	//$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."enConstruction.php\">modifier/supprimer un sujet</a>\n";
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."newSubject.php\">crer un sujet</a>\n";
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."enConstruction.php\">modifier/supprimer un questionnaire</a>\n";
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."newQuestionnaire.php\">crer un questionnaire</a>\n";
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."enConstruction.php\">modifier/supprimer une question</a>\n"; 
	$menuBar=$menuBar . "<a href=\"".PHPMCQ_HOME."newQuestion.php\">ajouter une question</a>\n"; 
	$menuBar=$menuBar . "</div>\n<br/></div>\n";
	}
	else
	{
	$menuBar=$menuBar . "</div>\n";
	}
    return ($config . $headerBar . $menuBar);
    }
	
function pageFooter()
{
    ///////////// The code of the default design is below ////////////
	$footer="";
    $footer=$footer . "<div class=\"footer\">";
	$footer=$footer . "<br/>";
	$footer=$footer . "<div class=\"bottom-menu\">";
	
	$footer=$footer . "<a href=\"".PHPMCQ_HOME."index.php\">Accueil</a>";
	$footer=$footer . "</div>\n";
	//$footer=$footer . italic("version : 0.2.0<br/>");
	$footer=$footer . "</div>\n";
    //////////////////////////////////////////////////////////////////
    
    ///////////////////// do NOT touch this part /////////////////////
    $config="";
    $config="</body></html>";
    //session_destroy();
    echo utf8_encode($footer . $config);
}
?>