<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newUser.php
Version : 	1.0
Date : 	    9th May 2004
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new people in database
*******************************************************************************/
	require_once('parameters.inc.php');
  require_once(PHPMCQ_HOME . 'PageLayout.class.php');
	require_once(PHPMCQ_HOME . 'xhtml.php');
	require_once(PHPMCQ_HOME . 'DataBase.class.php');
	require_once(PHPMCQ_HOME . 'Table.class.php');
	require_once(PHPMCQ_HOME . 'utils.php');
	
require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);
 
  $page=new PageLayout('WebQCM');
	$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
  $page->setTitleBar('<h1>Nouvel Utilisateur</h1>');
  
  $content='';
	/* get variables */
	$surname=getVariable('surname');
	$firstname=getVariable('firstname');
	$email=getVariable('email');
	$job=getVariable('job');
	$login=getVariable('login');
	$password1=getVariable('password1');
	$password2=getVariable('password2');
  $access=getVariable('access', USER);
	
    
	if(!isset($_REQUEST['btn-ok']))
	{
		$content = $content .  startForm($_SERVER['PHP_SELF']);
		$myTable = new Table('lightgrey');
		$myTable->line();
		$myTable->cell('Login : ');
		$myTable->cell(newTextField('login',$login));
		
		$myTable->line();
		$myTable->cell('Mot de passe : ');
		$myTable->cell(newPasswordField('password1'));
		
		$myTable->line();
		$myTable->cell('Confirmer le mot de passe : ');
		$myTable->cell(newPasswordField('password2'));
		
		$myTable->line();
		$myTable->cell('Nom :');
		$myTable->cell(newTextField('surname',$surname));
		
    $myTable->line();
	  $myTable->cell('Prnom :');
		$myTable->cell(newTextField('firstname',$firstname));
    
		$myTable->line();
	  $myTable->cell('Droits :');
    $accessSelect="<select name=\"access\" id=\"access\">\n";
    if($access== ADMIN) $select_option="selected=\"true\"";
    else $select_option="selected=\"false\"";
    $accessSelect=$accessSelect."<option value=\"" . ADMIN ."\" $select_option>Administrateur</option>\n";
    if($access== USER) $select_option="selected=\"true\"";
    else $select_option="selected=\"false\"";
    $accessSelect=$accessSelect."<option value=\"" . USER ."\" $select_option>Utilisateur</option>\n";
		$accessSelect=$accessSelect.'</select>';
		$myTable->cell($accessSelect);
    
    //$myTable->line();
		//$myTable->cell("e-mail :");
		//$myTable->cell(newTextField("email",$email));
	
    //$myTable->line();
		//$myTable->cell('Libre (promo) :');
		//$myTable->cell(newTextField('job',$job));
		
		$myTable->line();
		$myTable->cell(submitField('btn-ok','Valider')
			. submitField('btn-canceled',"Annuler"),'lightgrey','center',1,2);
        $content = $content . $myTable->endTable();
		//$thisPage = $thisPage .  hiddenField('valide',1);
		//$thisPage = $thisPage .  "<br/>\n";
		
	  $content = $content .  endForm();
	}	
	else // here we check for errors
	{
  	$canStore=true;
  	// login not already exist ? and is not empty ?
    $myDB = new dataBase();
		$request = "select * from people where login='$login'";
		$userExists=$myDB->execRequete($request);
    
    if(strlen($login)>0 && !$myDB->objetSuivant($userExists))
    {
    	$content = $content . "login '$login' ok<br />";
    }
    else
    {
    	$content = $content . "login '$login' failed<br />";
    	$canStore=false;
    }
    
    $password='';
		// password is the same ?
		if(strlen($password1)>0 && strcmp($password1,$password2) == 0)
		{
			$content = $content . "password '$password1' ok<br />";
      $password = md5 ($password1); 
		}
    else
    {
   		$content = $content . "password '$password1' failed<br />";
    	$canStore=false;
    }
    
    // Surname
  	if(strlen($surname)>0)
		{
			$content = $content . "Nom '$surname' ok<br />";
		}
    else
    {
   		$content = $content . "Nom '$surname' failed<br />";
    	$canStore=false;
    }
    
   	// Firstname
  	if(strlen($firstname)>0)
		{
			$content = $content . "Prnom '$firstname' ok<br />";
		}
    else
    {
   		$content = $content . "Prnom '$firstname' failed<br />";
    	$canStore=false;
    }
	

    // store in database
    if($canStore)
    {
			$request = "INSERT INTO people (login, surname, firstname, password, access)" . 
							"VALUES('$login', '$surname', '$firstname', '$password', $access)";
			$myDB->execRequete($request);
		
			if($myDB->enErreur()>=1)
			{
				$content = $content .  'erreur rencontre<br/>\n';
			}
		}
    
		$myDB->quitter();
	}
  
	$page->setContent($content);
	echo $page->getPage($_SESSION['access']);

?>
