<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

/*******************************************************************************
Name : 	    newSubject.php
Version : 	1.0
Date : 	    11th May 2004 
Author : 	Fabrice DUFOUR <Fabrice.Dufour@clubinfo.org>

Save new subject in database
*******************************************************************************/

	require_once("parameters.inc.php");
	require_once(PHPMCQ_HOME . 'PageLayout.class.php');
	require_once(PHPMCQ_HOME . 'xhtml.php');
	require_once(PHPMCQ_HOME . 'DataBase.class.php');
	require_once(PHPMCQ_HOME . 'Table.class.php');
	require_once(PHPMCQ_HOME . 'utils.php');
	
require_once(ACCESS_MODULE);
check_access(ADMINS_ONLY);
  
	$page=new PageLayout('WebQCM');
	$page->setStyleSheet(CSS_FILES_PATH . 'webQCM.css');
  $page->setTitleBar('<h1>Ajouter un sujet</h1>');
  
  $content=null;
  
	$subject=getVariable('subject');
	
	if(!isset($_REQUEST['btnValider']))
	{
		$content=$content."<br/>\n";
		$content = $content . startForm($_SERVER['PHP_SELF']);
		$myTable = new Table("lightgrey");
		$myTable->line();
		$myTable->cell("Sujet :");
		$myTable->cell(newTextField("subject",$subject));
		$myTable->line();
		$myTable->cell(submitField('btnValider','valider'),'lightgrey','center',1,2);
		$content = $content . centre($myTable->endTable());
		$content = $content . endForm();
	}	
	else
	{
		/*
		On ouvre une connection  la base de donnes 
		*/
		
		$myDB = new dataBase();
		
		/*
		On recherche que le sujet n'existe pas dj 
		*/
		
		$request = "SELECT subject FROM subjects WHERE subject='$subject'";
		$subjectsList=$myDB->execRequete($request);
		$content = $content . "<div class=\"status\">\n";
		
		/*
		On regarde si le sujet n'est pas vide
		*/
		
		if($subject=='')
		{
			$content = $content . 'Enregistrement du nouveau sujet [ '. bold(red("FAILED")) . "]<br/>\n";
			$content = $content . red('Le sujet est vide !') . "<br/>\n";
		}
		/*
		On regarde si le sujet existe dj
		*/
		elseif($myDB->objetSuivant($subjectsList))
		{
			$content = $content . 'Enregistrement du nouveau sujet [ '. bold(red("FAILED")) . "]<br/>\n";
			$content = $content . red('Le sujet existe dj !') . "<br/>\n";
		}
		/*
		Sinon on peut enregister le sujet
		*/
		else
		{
			$request = "INSERT INTO subjects (subject) VALUES('$subject')";
			$myDB->execRequete($request);
		
			if($myDB->enErreur()>=1)
			{
				$content = $content . 'Enregistrement du nouveau sujet [ '. bold(red("FAILED")) . "]<br/>\n";
				$content = $content . red('erreur du  la base de donnes') . "<br/>\n";
			}
			else
			{
				$content = $content . 'Enregistrement du nouveau sujet [ '. bold(green("OK")) . "]<br/>\n";
			}
			$myDB->quitter();
		}
		$content = $content . "</div>\n";
	}
  $page->setContent($content);
	echo $page->getPage($_SESSION['access']);
	//echo utf8_encode($page);
	//pageFooter();
?>
