<?php
/*******************************************************************************
    This file is part of phpMCQ.

    phpMCQ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMCQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*******************************************************************************/

require_once('parameters.inc.php');
require_once('xhtml.php');
require_once('Layout.class.php');

require_once(ACCESS_MODULE);
require_once(NOTIFICATION_MODULE);

class PageLayout extends Layout{
  
	function PageLayout($title){
		parent::Layout($title);
	}
    
	function getPage($access){
		header('Content-Type: text/xml');	
		$page=parent::getPage();
		$page=$page . parent::getHeader();
		$page=$page . "<body id=\"top\" onload=\"translate();\" onclose=\"if(self.screenTop>9000){alert('Closed.');}\">\n";
		$page=$page . $this->getTitleBar();
		$page=$page . $this->getMenu($access);
		// Possible notifications:
		$notes=Notes::getInstance();
		$page=$page . $notes->getHTMLFormatedNotes();
		$page=$page . parent::getContent();
		$page=$page . "</body>\n";
		$page=$page . parent::getFooter();

		return utf8_encode(stripslashes($page));
	}
    
	////////// TITLE //////////
	function setTitleBar($title){
		$this->headerBar=$title;
	}
    
	function getTitleBar(){
		return "<div id=\"header\">\n" . $this->headerBar . "</div>\n";
	}
     
	function item($name, $url){
		return "<dd class=\"item\">" . anchor($url, $name) . "</dd>\n";
	}
    
	function heading($name, $url=''){
		$tmp='';

		if(strlen($url)==0){
			$tmp="<dd class=\"heading\">" . $name . "</dd>\n";
		}
		else{
			$tmp=anchor($url, $name,'','heading');
		}
      
		return $tmp;
	}
    
	function getMenu($access){
		$tmp='';
		$tmp=$tmp . "<dl id=\"menu\">\n";
		$tmp=$tmp . "<dt id=\"menu-title\"> MENU </dt>";
		
		//-- Common menu for admins and users
		$tmp=$tmp . $this->heading('Choisir un questionnaire',PHPMCQ_HOME . 'chooseQuestionnaire.php');
		//-- Start of admin-tool
		// Users and admins can change their password
		$tmp=$tmp . $this->heading('Administrer webQCM');
		$tmp=$tmp . $this->item('Changer de mot de passe', PHPMCQ_HOME . 'changePassword.php');
		
		//-- Admins only features 
		if($access == ADMIN){
			$tmp=$tmp . $this->item('Crer un compte utilisateur', PHPMCQ_HOME . 'newUser.php');
			$tmp=$tmp . $this->heading('Sujet');
			$tmp=$tmp . $this->item('Crer un sujet', PHPMCQ_HOME . 'newSubject.php');
			//$tmp=$tmp . $this->item('Modifier un sujet', PHPMCQ_HOME . 'modifySubject.php');
			//$tmp=$tmp . $this->item('Supprimer un sujet', PHPMCQ_HOME . 'deleteSubject.php');
			$tmp=$tmp . $this->heading('Question');
			$tmp=$tmp . $this->item('Crer une question', PHPMCQ_HOME . 'newQuestion.php');
			//$tmp=$tmp . $this->item('Modifier une question', PHPMCQ_HOME . 'modifyQuestion.php');
			//$tmp=$tmp . $this->item('Supprimer une question', PHPMCQ_HOME . 'deleteQuestion.php');
			$tmp=$tmp . $this->heading('Questionnaire');
			$tmp=$tmp . $this->item('Crer un questionnaire', PHPMCQ_HOME . 'newQuestionnaire.php');
			//$tmp=$tmp . $this->item('Modifier un questionnaire', PHPMCQ_HOME . 'newUser.php');
			//$tmp=$tmp . $this->item('Supprimer un questionnaire', PHPMCQ_HOME . 'newUser.php');
			$tmp=$tmp . $this->heading('Statistiques');
			$tmp=$tmp . $this->item('Par matire', PHPMCQ_HOME . 'questStat.php');
			//$tmp=$tmp . $this->item('Par utilisateur', PHPMCQ_HOME . 'newUser.php');
		}
		
		$tmp=$tmp . "</dl>\n";
		return $tmp;
	}
}

?>
