<?php

	
	class DiagBarres
	{
		// Variables dtat
		var $image; 		// Lidentifiant de limage
		var $donnees; 	// Tableau associatif contenant les donnes
		var $nbVals; 		// Nombre de valeurs
		var $titre; 		// Le titre du diagramme
		
    // Mesures de positionnement
		var $largeur, $hauteur, $largeurLegende=0, $largeurDiag,
		$hauteurDiag, $hauteurBarre, $XDiag, $YDiag, $ecartVal,
		$marge = 20, $nbIntervalles=4;
		
    // Polices pour titre et lgende: taille, largeur, hauteur
		var $pLegende=2, $lpLegende, $hpLegende;
		var $pTitre=5, $lpTitre, $hpTitre;
		
    // Couleurs
		var $blanc, $noir, $bleu;

		// Constructeur de la classe
		function DiagBarres ($largeur, $hauteur, $donnees, $titre)
		{
			// Affectation des variables dtat
			$this->titre = $titre;
			$this->largeur = $largeur;
			$this->hauteur = $hauteur;
			$this->donnees = $donnees;
			$this->nbVals = count($this->donnees);
			// Affectation et calcul des tailles de police
			$this->hpLegende = ImageFontHeight ($this->pLegende);
			$this->lpLegende = ImageFontWidth ($this->pLegende);
			$this->hpTitre = ImageFontHeight ($this->pTitre);
			$this->lpTitre = ImageFontWidth ($this->pTitre);
			// Cration de limage et des couleurs
			$this->image= ImageCreate($this->largeur, $this->hauteur);
			$this->blanc = ImageColorAllocate($this->image, 255, 255, 255);
			$this->noir = ImageColorAllocate($this->image,0,0,0);
			$this->bleu = ImageColorAllocate($this->image,0,0,255);
			// Calcul de la largeur maximale dun texte de la lgende
			reset ($this->donnees);
			for ($i = 0; list($cle, $val) = each($this->donnees); $i++)
			{
				if ($this->lpLegende*strlen($cle) > $this->largeurLegende)
					$this->largeurLegende = $this->lpLegende*strlen($cle);
			}
		}
		
    // Affichage
		function affiche ()
		{
			$this->dessinFondImage ();
			$this->dessinTitre();
			$this->dessinBarres();
			$this->dessinReperes();
			header("Content-type: image/png");
			ImagePNG($this->image);
		}
		
    // Dessin du rectangle contenant le diagramme en barres
		function dessinFondImage ()	
		{
			// Hauteur maximale du diagramme
			$this->hauteurDiag = floor($this->hauteur - $this->marge*3 - $this->hpTitre);
			// Largeur du diagramme
			$this->largeurDiag = floor($this->largeur - 2 * $this->marge - $this->largeurLegende);
			// Position de dpart du diagramme (en haut  gauche)
			$this->XDiag = $this->marge + $this->largeurLegende + 5;
			$this->YDiag = $this->marge*2 + $this->hpTitre;
			// Hauteur dune barre
			$this->hauteurBarre = floor($this->hauteurDiag / $this->nbVals);
			// Calcul de la taille des intervalles
			$this->ecartVal = ceil(max($this->donnees) / $this->nbIntervalles);
			// Hauteur exacte du diagramme
			$this->hauteurDiag = $this->hauteurBarre * $this->nbVals;
			// Dessin du rectangle
			ImageRectangle($this->image, $this->XDiag, $this->YDiag,
			$this->XDiag + $this->largeurDiag,
			$this->YDiag + $this->hauteurDiag, $this->noir);
		}

		// Dessin du titre
		function dessinTitre()
		{
			$y = $this->marge;
			$x = ($this->largeur - strlen ($this->titre) * $this->lpTitre) / 2;
			ImageString($this->image, $this->pTitre, $x, $y,
			$this->titre, $this->noir);
		}
		
    // Dessin des repres verticaux avec leur tiquette
		function dessinReperes()
		{
			// Calcul de lintervalle de pixels entre chaque repre vertical
			$ecartPix = $this->largeurDiag / $this->nbIntervalles;
			// Dessin de chaque repre
			for ($i = 0; $i <= $this->nbIntervalles; $i++)
			{
				// Calcul de la valeur associe au repre
				$xVal = $i * $this->ecartVal;
				// Calcul de la position du repre et affichage
				$xpos = $this->XDiag + $i*$ecartPix;
				ImageLine($this->image, $xpos,$this->YDiag, $xpos,$this->YDiag + $this->hauteurDiag,$this->noir);
				// Calcul de la position du texte et affichage
				$posTexte = $xpos - (strlen($xVal)*$this->lpLegende)/2;
				ImageString($this->image, $this->pLegende,$posTexte,$this->YDiag+$this->hauteurDiag+5,$xVal, $this->noir);
			}
		}

		// Dessin des barres
		function dessinBarres()
		{
			// Espacement entre les barres, en pixels
			$espace = 6;
			// Nombre de pixels pour une unit
			$unitePix = $this->largeurDiag / ($this->ecartVal*$this->nbIntervalles);
			reset ($this->donnees);
			for ($i = 0; list($cle, $val) = each($this->donnees); $i++)
			{
				// Dessin des barres horizontales
				$xmin = $this->XDiag;
				$xmax = $xmin + (int)($val*$unitePix);
				$ymin = $this->YDiag + $i*$this->hauteurBarre + $espace/2;
				$ymax = $this->YDiag + ($i+1)*$this->hauteurBarre - $espace/2;
				ImageFilledRectangle($this->image, $xmin, $ymin, $xmax,$ymax, $this->bleu);
				// Affichage de la lgende,
				// cadre sur le bord gauche du diagramme
				$ypos = $ymin + ($this->hauteurBarre - $espace - $this->hpLegende) / 2;
				$xpos = $this->XDiag - $this->lpLegende*strlen($cle) - 2;
				ImageString($this->image, $this->pLegende,$xpos, $ypos, $cle, $this->noir);
			}
		}
  }
?>