<?
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Author : Jean-Christophe Cardot
   Copyright (c) 2000-2002 Jean-Christophe Cardot <taz98@altern.org>
 */

/* Link */
function relativepath2current ($path, $cwd) {
  /* pour cration de liens : donne le chemin relatif pour aller de $path
     au rpertoire $cwd (current working directory) */
  /* $path est un chemin relatif partant du rpertoire $cwd */
  $retval = ""; $retval2 = ""; $filename = "";
  if (!preg_match("/\/$/", $cwd)): $cwd .= "/"; endif;
  if (!is_dir($cwd.$path)): $filename = basename("./".$path); $path = dirname("./".$path); endif;
  /* nettoyage de $path => .. et . */
  $path = preg_replace("|^(\/)*|", "", $path);               /* "/" au dbut */
  $path = preg_replace("|^(\.\/)*|", "", $path);             /* "./" au dbut */
  $path = preg_replace("|(\/\.)*$|", "", $path);             /* "/."  la fin */
  $path = preg_replace("|\/\.\/(\.\/)*|", "/", $path);       /* "/./" au milieu */
  $oldpath="";
  while ($oldpath!=$path):
    $oldpath = $path;
    $path = preg_replace("|\w+(\s+\w+)*\/\.\.|", "", $path); /* "toto/.." supprim */
    $path = preg_replace("|\/(\/)*|", "/", $path);           /* "//" -> "/" */
  endwhile;
  $path = preg_replace("|^(\/)*|", "", $path);               /* "/" au dbut */
  if ($path && ($path!="./") && ($path!=".")):
    if (!preg_match("/\/$/", $path)): $path .= "/"; endif;
    /* maintenant on a un rpertoire, se terminant par "/" */
    /*  ce point, $path a t canonis, s'il remonte plus haut que le rpertoire
       courant, il commence par "../" (n fois) */
    $pathelements = explode("/", $path);
    $cwdelements = explode("/", $cwd);
    $cwdpos = count($cwdelements)-2;
    reset($pathelements);
    $pathelem=$pathelements[key($pathelements)];
    while ($pathelem==".."):
      $retval2 = "$cwdelements[$cwdpos]/$retval2";
      $cwdpos--;
      next($pathelements);
      $pathelem=$pathelements[key($pathelements)];
    endwhile;
    for (reset($pathelements); $pathelem=$pathelements[key($pathelements)]; next($pathelements)):
      if ($pathelem!=".."):
        $retval = "../$retval";
      endif;
    endfor;
  endif;
  return($retval.$retval2.$filename);
}

if ((count($selected)>0) && $destination):
  $logstr = "LN";
  echo $outputbegin;
  if ((count($selected)>1) && (!is_dir("$rep2browse/$destination"))):
    echo "<br>Erreur : pour lier plusieurs fichiers, la destination doit &ecirc;tre un r&eacute;pertoire";
  elseif (count($selected)>1): /* ici $destination est un rpertoire */
    if (!preg_match("/\/$/", $destination)):
      $destination .= "/";
    endif;
    $path2go = relativepath2current($destination, $rep2browse);
    chdir("$rep2browse/$destination"); /* on va dans le rpertoire destination */
    for(reset($selected); $dentry = $selected[key($selected)]; next($selected)):
      if (symlink($path2go.basename($dentry), basename($dentry))):
        $logstr .= " ($destination".basename($dentry)." -> ".basename($dentry).")";
        echo "<br>Lien <tt>$destination".basename($dentry)." -> ".basename($dentry)."</tt> cr&eacute;&eacute;\n";
      else:
        echo "<br>Impossible de cr&eacute;er le lien <tt>$destination".basename($dentry)." -> ".basename($dentry)."</tt>\n";
      endif;
    endfor;
    chdir($path2go); /* on retourne dans le rep $rep2browse */
    /* puis de l, on remonte jusqu' la racine : */
    $tmp = explode ("/", $rep2browse);
    for($i=0;$i<count($tmp);$i++): chdir(".."); endfor;
  else: /* ici on lie un seul fichier */
    $destination = "./$destination";
    if (is_dir("$rep2browse/$destination")):
      $destname .= basename($selected[0]);
    else:
      $destname = basename($destination);
      $destination = dirname($destination);
    endif;
    if (!preg_match("/\/$/", $destination)): $destination .= "/"; endif;
    $path2go = relativepath2current($destination, $rep2browse);
    if (!$path2go): $path2go="./"; endif;
    if (!preg_match("/\/$/", $path2go)): $path2go .= "/"; endif;
    chdir("$rep2browse/$destination"); /* on va dans le rpertoire destination */
    if (symlink($path2go.basename($selected[0]), $destname)): /* on y cre le lien */
      $logstr .= " ($destination$destname -> ".basename($selected[0]).")";
      echo "<br>Lien <tt>$destination$destname -> ".basename($selected[0])."</tt> cr&eacute;&eacute;";
    else:
      echo "<br>Impossible de cr&eacute;er le lien <tt>$destination$destname -> ".basename($selected[0])."</tt>";
    endif;
    chdir($path2go); /* on retourne dans le rep $rep2browse */
    /* puis de l, on remonte jusqu' la racine : */
    $tmp = explode ("/", $rep2browse);
    for(reset($tmp); $dentry = $tmp[key($tmp)]; next($tmp)):
      if ($dentry!="."): chdir(".."); endif;
    endfor;
  endif;
  echo $outputend;
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], $logstr);
endif;

?>
