<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

function Terminologie ($categorie,$genre,$nombre,$article,$adjectif,$majuscule)
{
	// Cette fonction permet d'afficher de faon dynamique le terme adquat de chaque
	// catgorie conformment  la termonilogie choisie par l'administrateur de l'application.
	
	// $categorie -> dtermine la catgorie, ne peut contenir que trois valeurs distinctes : 'proj' (projets), 'dom' (domaines) ou 'tache' (tches)
	// $genre -> dtermine le genre du nom de la catgorie : 0 = fminin, 1 = masculin
	// $nombre -> dtermine s'il faut afficher le nom de la catgorie au singulier ou au pluriel ; toute autre valeur que 'plur' affichera le singulier
	// $article -> dtermine l'article ou le dterminant ventuel  afficher devant le nom de la catgorie ; cette variable doit avoir pour valeur l'article ou le dterminant choisi au masculin singulier, la fonction se charge de l'adapter en fonction de la valeur des variables $genre et $nombre ; chane vide si pas d'article
	// $adjectif -> affiche un adjectif ventuel entre l'article et le nom de la catgorie ; mmes rgles que pour la variable $article ; voir le corps de la fonction pour crer de nouveaux adjectifs
	// $majuscule -> boolen dterminant s'il faut afficher le nom avec une majuscule au dbut (TRUE) ou sans majuscule (FALSE)
	
	$chaine = "";
	
	switch ($article) // choix de l'article
	{
		case 'le':
			if ($nombre == 'plur')
			{
				$chaine .= "les ";
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "la ";
				}
				else
				{
					$chaine .= "le ";
				}
			}
			break;
		case 'ce':
			if ($nombre == 'plur')
			{
				$chaine .= "ces ";
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "cette ";
				}
				else
				{
					$chaine .= "ce ";
				}
			}
			break;
		case 'un':
			if ($nombre == 'plur')
			{
				$chaine .= "des ";
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "une ";
				}
				else
				{
					$chaine .= "un ";
				}
			}
			break;
		case 'quel':
			if ($nombre == 'plur')
			{
				if ($genre == 0)
				{
					$chaine .= "quelles ";
				}
				else
				{
					$chaine .= "quels ";
				}
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "quelle ";
				}
				else
				{
					$chaine .= "quel ";
				}
			}
			break;
		case 'au':
			if ($nombre == 'plur')
			{
				$chaine .= "aux ";
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "&agrave; la ";
				}
				else
				{
					$chaine .= "au ";
				}
			}
			break;
		case 'du':
			if ($nombre == 'plur')
			{
				$chaine .= "des ";
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "de la ";
				}
				else
				{
					$chaine .= "du ";
				}
			}
			break;
		case 'aucun':
			if ($genre == 0)
			{
				$chaine .= "aucune ";
			}
			else
			{
				$chaine .= "aucun ";
			}
			break;
		case 'tous':
			if ($nombre == 'plur')
			{
				if ($genre == 0)
				{
					$chaine .= "toutes les ";
				}
				else
				{
					$chaine .= "tous les ";
				}
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "toute la ";
				}
				else
				{
					$chaine .= "tout le ";
				}
			}
			break;
		default:
			$chaine .= "";
			break;
	}
	
	switch ($adjectif) // ventuel adjectif avant le nom
	{
		case 'nouveau':
			if ($nombre == 'plur')
			{
				if ($genre == 0)
				{
					$chaine .= "nouvelles ";
				}
				else
				{
					$chaine .= "nouveaux ";
				}
			}
			else
			{
				if ($genre == 0)
				{
					$chaine .= "nouvelle ";
				}
				else
				{
					$chaine .= "nouveau ";
				}
			}
			break;
		default:
			$chaine .= "";
			break;
	}
	
	switch ($categorie) // choix de la catgorie (projet, domaine ou tche)
	{
		case 'proj':
			if ($nombre == 'plur')
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_proj_plur']);
				}
				else
				{
					$chaine .= $_SESSION['conf_proj_plur'];
				}
			}
			else
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_proj_sing']);
				}
				else
				{
					$chaine .= $_SESSION['conf_proj_sing'];
				}
			}
			break;
		case 'dom':
			case 'proj':
			if ($nombre == 'plur')
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_dom_plur']);
				}
				else
				{
					$chaine .= $_SESSION['conf_dom_plur'];
				}
			}
			else
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_dom_sing']);
				}
				else
				{
					$chaine .= $_SESSION['conf_dom_sing'];
				}
			}
			break;
		case 'tache':
			case 'proj':
			if ($nombre == 'plur')
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_tache_plur']);
				}
				else
				{
					$chaine .= $_SESSION['conf_tache_plur'];
				}
			}
			else
			{
				if ($majuscule)
				{
					$chaine .= ucfirst($_SESSION['conf_tache_sing']);
				}
				else
				{
					$chaine .= $_SESSION['conf_tache_sing'];
				}
			}
			break;
	}
	
	return $chaine;
}

?>