/*
 * testprog2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-09-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <stdlib.h>
#include <pds/pdssn.h>

int main(int argc, char** argv)
{
	PdsNeuron *Neuron=NULL;
	PdsSnReal m,r=0.9;
	PdsNInput *A[4];
    int i;

	////////////////////////////////////////////////////////////////////////

	Neuron=pds_neuron_new(4);
	if(Neuron==NULL)	printf("ERROR: La neurona no ha podido crearse.\n");
	else
	{
		A[0]=pds_ninput_new();	pds_ninput_set_input(A[0], 1.0);
		A[1]=pds_ninput_new();	pds_ninput_set_input(A[1], 0.5);
		A[2]=pds_ninput_new();	pds_ninput_set_input(A[2],-0.3);
		A[3]=pds_ninput_new();	pds_ninput_set_input(A[3],-1.7);

		pds_neuron_connect_input_with_ninput(Neuron,0,A[0]);
		pds_neuron_connect_input_with_ninput(Neuron,1,A[1]);
		pds_neuron_connect_input_with_ninput(Neuron,2,A[2]);
		pds_neuron_connect_input_with_ninput(Neuron,3,A[3]);


        i=0;
		pds_neuron_init_weight_rand(Neuron,-0.1,0.1);
        do{
   		    printf("Try <<%3d>>\n",i);
    		printf("X{:}=\n%f\t%f\t%f\t%f\n",*(Neuron->X[0]),*(Neuron->X[1]),*(Neuron->X[2]),*(Neuron->X[3]));
		    printf("W{:}=\n%f\t%f\t%f\t%f\n",Neuron->W[0],Neuron->W[1],Neuron->W[2],Neuron->W[3]);

		    pds_neuron_iterate(Neuron);

		    pds_neuron_get_output(Neuron,&m);
		    printf("Y=%f\n",m);
        
            pds_neuron_evaluate_diff_error(Neuron,r);
		    printf("e=%f\n\n",Neuron->Y[1]);
            
            if((r-m)>0.01)
            {
                pds_neuron_update_u_and_weight_normalized(Neuron, 5.0);
            }
            else break;
            i++;

        }while(1);

		pds_ninput_destroy(&A[0]);
		pds_ninput_destroy(&A[1]);
		pds_ninput_destroy(&A[2]);
		pds_ninput_destroy(&A[3]);

		pds_neuron_destroy(&Neuron);
		if(Neuron==NULL) printf("\nLa neurona Neuron ha sido liberado y limpiada.\n");
	}
	////////////////////////////////////////////////////////////////////////

	printf("\n");

	return EXIT_SUCCESS;
}
