
#include <stdlib.h>
#include <pds/pdssn.h>
    

int main(int argc, char** argv)
{
    PdsSnReal X[4]={1.0, 0.5, -0.3, -1.7};
    PdsSnNatural N=4;
    PdsSnReal Out;
    
    // Creating an input vector of N elements
    PdsNIVector *Input=pds_nivector_new(N);
    // Creating a neuron with N inputs
    PdsNeuron *Neuron=pds_neuron_new(N);
    
    if( (Input==NULL)||(Neuron==NULL) ) return EXIT_FAILURE;
    
    // Connect the input vector with the input of neuron
    pds_neuron_connect_input_with_nivector(Neuron,Input);
    
    // Initializing weights and print the values
    pds_neuron_init_u_and_weight_rand(Neuron,-1.0,+1.0);
    pds_neuron_printf_u_and_weight(Neuron);
    
    // Copy the X array in the input vector
    pds_nivector_set_input_from_array(Input,X,N);
    
    // Iterate the neuron
    pds_neuron_iterate(Neuron);
    
    // Get the output value of neuron
    pds_neuron_get_output(Neuron,&Out);
    printf("Y=%7.3f\n",Out);
    
    // Release the memory
    pds_nivector_destroy(&Input);
    pds_neuron_destroy(&Neuron);
    
    return EXIT_SUCCESS;
}
