%

function mycolormap(COLORMAP)

C=round(COLORMAP*255);
R=C(:,1);
G=C(:,2);
B=C(:,3);

M=256;
N=length(R);
x=[0:N-1];
xx=linspace(0,N-1,M);

RR = round(interp1(x,R,xx))'
GG = round(interp1(x,G,xx))'
BB = round(interp1(x,B,xx))'

    fprintf('unsigned char PDS_COLORMAP_[256][3]=\n');
    fprintf('{\n');
    for II=1:M
        fprintf('    {%3d,%3d,%3d},\n',RR(II),GG(II),BB(II));
    end
    fprintf('};\n');

X=[0:M-1];
plot(X,RR,'r->',X,GG,'g-s',X,BB,'b-o'); 
hl=legend('RED','GREEN','BLUE');
set(hl,'location','northeastoutside');
xlim([0 M-1]);
saveas(gcf,'colormap.png');

end
