/*
 * pdsra.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsra.h
 * \brief Archivo de definición de cabeceras.
 *
 *  Puedes habilitar todos los módulos de la biblioteca  
 *  usando este archivo, haciendo:
   @verbatim
	#include <pds/pdsra.h>
   @endverbatim
 * O puedes habilitarlas una por una usando lo siguiente:
   @verbatim
	#include <pds/pdsmatrix.h>
	#include <pds/pdsvector.h>
   @endverbatim
 * 
 */


#ifndef __PDSRA_H__
#define __PDSRA_H__

#include <pds/pdsrautils.h>
#include <pds/pdsmatrix.h>
#include <pds/pdsvector.h>
#include <pds/pdslvector.h>
#include <pds/pdsfifo.h>

#endif /* __PDSRA_H__ */
